/*------------------------------------------*\
 | Return the length of string s, EXCLUDING	|
 | the \0 at the end of it.					|
\*------------------------------------------*/
StringLen(s)
char *s;
{
	int Count = 0;

	while(*s++ != '\0')
		Count++;

	return(Count);
}




/*----------------------------------------------*\
 | Copy a string From to string To including	|
 | the \0 at the end of string From.			|
\*----------------------------------------------*/
StringCopy(From, To)
register char *From;
register char *To;
{
	while((*To++ = *From++) != '\0');
	return;
}




/*----------------------------------------------*\
 | Ret 0 when strings equal, 1 when different	|
\*----------------------------------------------*/
StringDiff(s1, s2)
char *s1;
char *s2;
{
	while(*s1 == *s2) {
		if(*s1 == '\0') {	/* and thus *s2 == '\0'	*/
			return(0);
		}
		s1++; s2++;
	}
	return(1);			/* strings differ	*/
}



/*----------------------------------------------*\
 | Ret 0 when strings equal, 1 when different	|
 | Not more than Len chars are compared			|
\*----------------------------------------------*/
StringNDiff(s1, s2, Len)
char *s1;
char *s2;
int   Len;
{
	while(*s1 == *s2) {
		Len--;
		if(*s1 == '\0' || Len == 0) {	/* and thus *s2 == '\0'	*/
			return(0);
		}
		s2 += 1;
		s1 += 1;
	}
	return(1);			/* strings differ	*/
}



/*--------------------------------------*\
 | Put a '\0' at the end of string s	|
\*--------------------------------------*/
void
NullEnd(s, MaxLen)
register char *s;
register int   MaxLen;
{
	while(*s != '\n' && *s != '\r' && *s != '\0' && MaxLen--)
		s++;

	*s = '\0';
	return;
}






/*--------------------------------------*\
 | Check if arg CheckChar is any of the	|
 | characters in array List.			|
\*--------------------------------------*/
AnyChar(CheckChar, List)
char  CheckChar;
char *List;
{
	while(*List != '\0') {
		if(CheckChar == *List)
			return(1);

		List++;
	}
	return(0);
}
