#include <stdio.h>
#include "defines.h"
#include "xdefs.h"



void
ShowCover()
{
	int      NSongs1, NSongs2;

	if(CurIt == (CATITEM *)0) {
		Attention("First retrieve the cover you wish to display");
		return;
	}

	/*
	 * Show global data of this cover
	 */
	NLines(SCRLINES - 6 - 1);
	ShowGlobal(CurIt, CurCass);
	NLines(1);
	RetCont();

	NSongs1 = CountSongs(CurCass->Side1);
	NSongs2 = CountSongs(CurCass->Side2);

	/*
	 * When all songs fit on one screen, do so, else on two screens.
	 * -1 and -1 are for the headers printed by ShowSongs(),
	 * First -1 for NLines(1) separator between side 1 and 2
	 * -1 and -1 for NLines(1) and for RetCont().
	 */
	if(NSongs1 + NSongs2 < (SCRLINES -1 -1 -1 -1 -1)) {
		NLines(SCRLINES - (NSongs1+1) -1 - (NSongs2+1) -1);
		ShowSongs(CurCass->Side1, 1);
		NLines(1);
		ShowSongs(CurCass->Side2, 2);
		NLines(1);
		RetCont();
		return;
	}

	/*
	 * Show Songs of Side 1
	 */
	NLines(SCRLINES - NSongs1-1 - 1);
	ShowSongs(CurCass->Side1, 1);
	NLines(1);
	RetCont();

	/*
	 * Show Songs of Side 2
	 */
	NLines(SCRLINES - NSongs2-1 - 1);
	ShowSongs(CurCass->Side2, 2);
	NLines(1);
	RetCont();
	return;
}

void
ShowGlobal(It, Cas)
CATITEM *It;
CASS    *Cas;
{
	printf("  description: %s\n", It->Description);
	NLines(1);
	printf("  Tape type:    ");
	switch(Cas->TapeType) {
	case FEO3:
		printf("FERRO;    ");
		break;

	case CRO2:
		printf("CHROME;   ");
		break;

	case FECR:
		printf("FECR;     ");
		break;

	case METAL:
		printf("METAL;    ");
		break;

	default:
		printf("UNKNOWN; ");
		break;
	}

	printf("Noise reduction: ");
	switch(Cas->NoiseReduction) {
	case DOLBY_B:
		printf("DOLBY B;");
		break;
	case DOLBY_C:
		printf("DOLBY C;");
		break;
	case DBX:
		printf("DBX;");
		break;
	case HXPRO:
		printf("HX-PRO;");
		break;
	case NO_NR:
		printf("NONE");
		break;
	default:
		printf("UNKNOWN;");
		break;
	}

	printf("  Back code   : %s\n", Cas->BackCode);
	printf("  Back title 1: %s\n", Cas->BackTl1);
	printf("  Back title 2: %s\n", Cas->BackTl2);
	NLines(1);
	return;
}


void
ShowSongs(Song, Side)
SONG *Song;
int   Side;
{
	int Count = 0;

	printf("  TITLES ON SIDE %d:\n", Side);
	while(Song != (SONG *)0) {
		Count++;
		/*
		 * Check if counter is given
		 */
		if(*(Song->Count) == '\0') {
			printf("%2d) %s\n", Count, Song->Title);
		} else {
			printf("%2d) %5s: %s\n", Count, Song->Count, Song->Title);
		}
		Song = Song->Next;
	}
	return;
}
