#include <stdio.h>
#include "xdefs.h"
#include "defines.h"

#define NUM(p)	((p) >= '0' && (p) <= '9')

#define TO_NUM1			1
#define NUM1			2
#define CHECK_IF_RANGE	3
#define TO_NUM2			4
#define NUM2			5

/*----------------------------------------------*\
 | Select the items of which the numbers are	|
 | typed in. The format is very simple:			|
 | 												|
 |  2,3,8-10,20,22								|
 |												|
 | The dash indicates a range.					|
 | The comma is a separator, but SPACE, ';',	|
 |			'.' and TAB are also OK				|
 | Space may be inserted anywhere except in a	|
 | number (this would cause it to be read as 2	|
 | smaller numbers								|
\*----------------------------------------------*/
DoSelect(What, MaxNum)
int What;
int MaxNum;
{
	char  Buf[200];
	char  c;
	char *Cp;
	int   Num1;
	int   Num2;
	int   Mode;
	int   i;

	gets(Buf);
	Cp = Buf;
	while(*Cp != '\n' && *Cp != '\r' && *Cp != '\0')
		Cp++;

	*Cp++ = '.';  *Cp = '\0';	/* Put . at end of string	*/

	Cp = Buf;

	/*
	 * When we typed a '*' at the beginning of the
	 * line, all numbers are selected
	 */
	if(*Cp == '*') {		/* ALL numbers selected	*/
		for(i = 1; i <= MaxNum; i++)
			Select(What, i, MaxNum);
		return(0);
	}

	Mode = TO_NUM1;

	while((c = *Cp++) != '\0') {
		switch(Mode) {
		case TO_NUM1:
			if(AnyChar(c, "\t .,;"))	/* Skip separators	*/
				continue;

			if(!NUM(c))
				return(-1);

			Num1 = 0;
			Mode = NUM1;
			Cp--;			/* rewind one character	*/
			break;

		case NUM1:
			if(NUM(c)) {
				Num1 *= 10;
				Num1 += c - '0';
				break;
			}
			if(AnyChar(c, " \t")) {	/* is this a range ?	*/
				Mode = CHECK_IF_RANGE;	/* if no range, do num1	*/
				break;
			}
			if(c == '-') {		/* range specification	*/
				Mode = TO_NUM2;
				break;
			}
			if(AnyChar(c, ",.;")) {	/* number separator	*/
				Select(What, Num1, MaxNum);
				Mode = TO_NUM1;
				break;
			}
			return(-1);			/* illegal character	*/

		case CHECK_IF_RANGE:
			if(AnyChar(c, " \t"))
				break;
			if(c == '-') {
				Mode = TO_NUM2;
				break;
			}
			if(AnyChar(c, ",.;") || NUM(c)) {
	
				Select(What, Num1, MaxNum);	/* did not do this yet	*/
				/*
				 * When a number, 'backspace' one char
				 */
				if(NUM(c))
					Cp--;
				Mode = TO_NUM1;
				break;
			}
			return(-1);
		
		case TO_NUM2:
			if(AnyChar(c, "\t .,;"))	/* Skip separators	*/
				continue;

			if(!NUM(c))
				return(-1);

			Num2 = 0;
			Mode = NUM2;
			Cp--;			/* rewind one character	*/
			break;

		case NUM2:
			if(NUM(c)) {
				Num2 *= 10;
				Num2 += c - '0';
				break;
			}
			if(AnyChar(c, ",.;")) {	/* number separator	*/
				for(i = Num1; i <= Num2; i++)
					Select(What, i, MaxNum);
				Mode = TO_NUM1;
				break;
			}
			return(-1);			/* illegal character	*/
		}
	}
	return(0);
}




/*------------------------------*\
 | Select the specified item	|
\*------------------------------*/
void
Select(What, Num, MaxNum)
int What;
int Num;
int MaxNum;
{
	CATITEM *ItPt;
	SONG    *SongP;

	if(Num > MaxNum || Num <= 0) {
		return;
	}

	Num--;
	if(What == CAT_ITEMS) {
		ItPt = FirstCatIt;

		while(Num--)
			ItPt = ItPt->Next;

		ItPt->Status |= SELECTED;
	} else {
		if(What == SONGS1) {
			SongP = CurCass->Side1;
		} else {
			SongP = CurCass->Side2;
		}
		while(Num--)
			SongP = SongP->Next;

		SongP->Status |= SELECTED;
	}
	return;
}



/*------------------------------*\
 | Deselect all selected items	|
\*------------------------------*/
void
UnSelect(What)
int What;
{
	CATITEM *ItPt;

	if(What == CAT_ITEMS) {
		ItPt = FirstCatIt;
		while(ItPt != (CATITEM *)0) {
			ItPt->Status &= ~SELECTED;
			ItPt = ItPt->Next;
		}
	}
	return;
}
