#include <stdio.h>
#include "defines.h"
#include "xdefs.h"

void
ReadACover()
{
	char Buf[100];
	int  Num;

	ClearCurr();

	ListCovers(ALL);
	printf(" Which cover do you want to retrieve ? ..."); fflush(stdout);
	gets(Buf);
	Num = atoi(Buf);

	if(Num == 0) return;	/* no number entered ... */
	if(Num > NCatItems) {
		Attention("Cover number %d is too high, %d maximum ...",
													Num, NCatItems);
		return;
	}

	CurIt = FirstCatIt;
	while(--Num)
		CurIt = CurIt->Next;

	/*
	 * We have the right item now !!
	 */
	ReadCover(CurIt, CurCass);
	return;
}

#define LINELEN   80
#define NOCOVFILE "File %s, Line %d is no cover file"


void
ReadCover(It, Cass)
CATITEM *It;
CASS    *Cass;
{
	FILE  *Fp;
	char   Buf[LINELEN];
	char  *Cp;
	char   Side;
	SONG  *NewS;
	SONG  *SongP;
	SONG **List;
	int    LineNum = 1;

	/*
	 * Open file
	 */
	if((Fp = fopen(It->FileName, "r")) == NULL) {
		Panic("Cannot open cover file %s for reading", It->FileName);
	}

	/*
	 * Check if the first  line contains a magic
	 */
	if(fgets(Buf, LINELEN-1, Fp) == NULL)
		Panic(NOCOVFILE, It->FileName, LineNum);


	NullEnd(Buf, LINELEN-1);
	if(StringDiff(Buf, CASSMAGIC))
		Panic(NOCOVFILE, It->FileName, LineNum);

	while(fgets(Buf, LINELEN-1, Fp) != NULL) {
		NullEnd(Buf, LINELEN-1);
		LineNum++;
		Cp = Buf;
		if(*Cp++ != '#')
			Panic(NOCOVFILE, It->FileName, LineNum);

		switch(*Cp++) {
		case 'S':			/* TAPETYPE			*/
			Cass->TapeType = *Cp;
			break;

		case 'N':			/* NOISEREDUCTION SYSTEM	*/
			Cass->NoiseReduction = *Cp;
			break;

		case 'C':			/* CODE ON BACK OF COVER	*/
			Cass->BackCode = NewString(Cp);
			break;

		case 'T':			/* BACKTITLE 1 AND 2		*/
			if(*Cp++ == '1') {
				Cass->BackTl1 = NewString(Cp);
			} else {
				Cass->BackTl2 = NewString(Cp);
			}
			break;

		case 'c':			/* TAPECOUNT OF SONG 		*/
			Side = *Cp++;

			/*
			 * So a new song must be allocated.
			 */
			NewS = NewSong();
			NewS->Next = (SONG *)0;

			NewS->Count = NewString(Cp);

			/*
			 * Now link it into the right list.
			 */
			if(Side == '1')
				List = &(Cass->Side1);
			else
				List = &(Cass->Side2);


			if(*List == (SONG *)0) {	/* the very first song !	*/
				*List = NewS;
			} else {
				/*
				 * Now first find the end of the list
				 */
				SongP = *List;
					while(SongP->Next != (SONG *)0) /* find end of songlist */ {
					SongP = SongP->Next;
				}

				SongP->Next = NewS;
			}


			/*
			 * New song is linked at the end of the right list.
			 * Now read a line which MUST contain a songtitle
			 */
			LineNum++;
			if(fgets(Buf, LINELEN-1, Fp) == NULL)
				Panic("Cover file %s illegal; title expected!", It->FileName);

			NullEnd(Buf, LINELEN-1);
			if(Buf[0] != '#' || Buf[1] != Side)
				Panic("Cover file %s illegal; title expected!", It->FileName);

			NewS->Title = NewString(Buf+2);
			break;

		default:
			Panic("Illegal line in cover file: %s", Buf);
		}
	}
}
