#include <stdio.h>
#include "xdefs.h"
#include "defines.h"

static  char  ParamFile1[] = PARAMFILE1;
static  char  ParamFile2[] = PARAMFILE2;
static	char *ParamFile;
static  int   LCount;	/* line counter			*/
static  FILE *PFp;		/* Param file pointer	*/

extern void	ReadInt();
extern void ReadCoord();
extern void ReadString();
extern void GetLine();

void
InitParams()
{
	if((PFp = fopen(ParamFile1, "r")) == NULL) {
		if((PFp = fopen(ParamFile2, "r")) == NULL) {
			Panic("Can't open parameter file %s\n       or %s for reading\n",
										ParamFile1, ParamFile2);
		} else {
			ParamFile = ParamFile2;
		}
	} else {
		ParamFile = ParamFile1;
	}

	LCount = 0;
	ReadCoord(&CodeXPos, &CodeYPos);
	ReadInt(&CodeLen);
	ReadString(&CodeFont);
	ReadInt(&CodeFSize);

	ReadCoord(&TsXPos, &TsYPos);
	ReadCoord(&NrXPos, &NrYPos);
	ReadString(&TsNrFont);
	ReadInt(&TsNrFSize);

	ReadCoord(&BT1XPos, &BT1YPos);
	ReadCoord(&BT2XPos, &BT2YPos);
	ReadInt(&BTLen);
	ReadString(&BTFont);
	ReadInt(&BTFSize);

	ReadCoord(&FrAXPos, &FrAYPos);
	ReadCoord(&FrBXPos, &FrBYPos);
	ReadString(&FrABFont);
	ReadInt(&FrABFSize);

	ReadCoord(&FrTl1XPos, &FrTl1YPos);
	ReadCoord(&FrTl2XPos, &FrTl2YPos);
	ReadString(&FrTlFont);
	ReadInt(&FrTlFSize);

	ReadCoord(&Tl1XPos, &Tl1YPos);
	ReadCoord(&Tl2XPos, &Tl2YPos);
	ReadInt(&TlLen);
	ReadInt(&TlLDist);
	ReadString(&TlFont);
	ReadInt(&TlFSize);

	ReadInt(&CtTlXDist);
	ReadInt(&CtLen);

	ReadInt(&FTlSepX1);
	ReadInt(&FTlSepX2);
	ReadInt(&FTlSepY);

	ReadInt(&FVSepX);
	ReadInt(&FVSepY1);
	ReadInt(&FVSepY2);

	fclose(PFp);
}

static char LBuf[100];

static void
ReadInt(Num)
int *Num;
{
	GetLine();
	*Num = atoi(LBuf);
	return;
}


static void
ReadCoord(Num1, Num2)
int *Num1;
int *Num2;
{
	char *Cp;

	GetLine();
	*Num1 = atoi(LBuf);

	/*
	 * Find start of second number
	 */
	Cp = LBuf;
	/*
	 * Skip number first
	 */
	while(*Cp >= '0' && *Cp <= '9')
		Cp++;

	/*
	 * Find next number
	 */
	while(*Cp != '\n' && *Cp != '\0' && !(*Cp >= '0' && *Cp <= '9')) {
		switch(*Cp) {
		case ',':
		case ';':
		case ' ':
		case '\t':
			Cp++;
			continue;

		default:
			Panic("Illegal character %c in line %d of file %s", *Cp,
								LCount, ParamFile);
		}
	}
	if(*Cp == '\n' || *Cp == '\0') {
		Panic("Line %d in parameter file %s too short; second param expected",
							LCount, ParamFile);
	}
	*Num2 = atoi(Cp);
	return;
}




static void
ReadString(StringP)
char **StringP;
{
	char *Cp;

	GetLine();

	/*
	 * Delete comment
	 */
	Cp = LBuf;
	while(*Cp != '#' && *Cp != '\n' && *Cp != '\0')
		Cp++;

	*Cp = '\0';
	*StringP = NewString(LBuf);
	return;
}


static void
GetLine()
{
	LBuf[0] = '#';
	while(LBuf[0] == '#') {
		if(fgets(LBuf, 80, PFp) == NULL)
			Panic("Premature END-OF-FILE in file %s\n", ParamFile);

		LCount++;
	}
	return;
}
