#include <stdio.h>
#include "xdefs.h"
#include "defines.h"

static CASS OutCass[4];
static FILE *CovFp;


extern void CovOutput();



void
OutCovers(Func)
int Func;
{
	int      CovCount;
	CATITEM *It;


	ListCovers(ALL);

	printf(" Enter the numbers of the cover to be\n printed (to disk): ");
	fflush(stdout);

	DoSelect(CAT_ITEMS, NCatItems);	/* ask numbers of covers to delete */
	ListCovers(Func);

	printf("\n Do you want to print these covers to postscript file ? (y/n) ");
	fflush(stdout);

	if(!Confirm()) {
		UnSelect(CAT_ITEMS);
		return;
	}

	CovCount = 0;
	It = FirstCatIt;
	/*
	 * read in the covers in  groups of four and output them.
	 */
	if((CovFp = fopen("COVERS.PS", "w")) == NULL)
		Panic("Can't create output file");

	while(It != (CATITEM *)0) {
		if((It->Status & SELECTED) == 0)  {
			It = It->Next;
			continue;
		}
		ReadCover(It, &(OutCass[CovCount]));
		CovCount++;
		if((CovCount % 4) == 0) {
			CovOutput(CovCount);
			CovCount = 0;
		}
		It = It->Next;
	}
	CovOutput(CovCount);
	fclose(CovFp);
}


static void
CovOutput(NCovs)
int NCovs;
{
	int   CovCount;
	CASS *OutC;
	SONG *SongP;
	int   SongY;

	if(NCovs == 0) return;

	fprintf(CovFp, "%%!\n");

	/*
	 * tenths of millimeters:
	 */
	fprintf(CovFp, "/tmm { 0.283464 mul } def\n");
	fprintf(CovFp, "90 rotate\n");
	fprintf(CovFp, "150 tmm -2100 tmm translate\n");




	for(CovCount = 0; CovCount < NCovs; CovCount++) {
		switch(CovCount) {
		case 0:
			OutC = OutCass;
			fprintf(CovFp, "80 tmm 70 tmm translate\n");
			break;
		case 1:
			OutC = &(OutCass[1]);
			fprintf(CovFp, "1070 tmm 0 tmm translate\n");
			break;
		case 2:
			OutC = &(OutCass[2]);
			fprintf(CovFp, "0 tmm 970 tmm translate\n");
			break;
		case 3:
			OutC = &(OutCass[3]);
			fprintf(CovFp, "-1070 tmm 0 tmm translate\n");
			break;
		default:
			Panic("Error in output routine; CovCount = %d!\n", CovCount);
		}
		/*
		 * Draw lines first
		 */
		fprintf(CovFp, "newpath\n");

		fprintf(CovFp, "0.1 setlinewidth\n");

		/*
		 * upper two folding lines
		 */
		fprintf(CovFp, "1 tmm 295 tmm moveto\n");
		fprintf(CovFp, "3 tmm 295 tmm lineto\n");
		fprintf(CovFp, "1011 tmm 295 tmm moveto\n");
		fprintf(CovFp, "1013 tmm 295 tmm lineto\n");

		/*
		 * lower two folding lines
		 */
		fprintf(CovFp, "1 tmm 160 tmm moveto\n");
		fprintf(CovFp, "3 tmm 160 tmm lineto\n");
		fprintf(CovFp, "1011 tmm 160 tmm moveto\n");
		fprintf(CovFp, "1013 tmm 160 tmm lineto\n");

		/*
		 * Top cutting line
		 */
		fprintf(CovFp, "1 tmm 960 tmm moveto\n");
		fprintf(CovFp, "1015 tmm 960 tmm lineto\n");

		/*
		 * Bottom cutting line
		 */
		fprintf(CovFp, "1 tmm 1 tmm moveto\n");
		fprintf(CovFp, "1015 tmm 1 tmm lineto\n");

		/*
		 * Left cutting line
		 */
		fprintf(CovFp, "1 tmm 1 tmm moveto\n");
		fprintf(CovFp, "1 tmm 960 tmm lineto\n");

		/*
		 * Right cutting line
		 */
		fprintf(CovFp, "1015 tmm 1 tmm moveto\n");
		fprintf(CovFp, "1015 tmm 960 tmm lineto\n");



		/*
		 * Horizontal line on the front
		 * Vertical line in the middle
		 */
		fprintf(CovFp, "0.5 setlinewidth\n");
		fprintf(CovFp, "%d tmm %d tmm moveto\n", FTlSepX1, FTlSepY);
		fprintf(CovFp, "%d tmm %d tmm lineto\n", FTlSepX2, FTlSepY);

		fprintf(CovFp, "%d tmm %d tmm moveto\n", FVSepX, FVSepY1);
		fprintf(CovFp, "%d tmm %d tmm lineto\n", FVSepX, FVSepY2);

		fprintf(CovFp, "stroke\n");



		/*
		 * 'Designed by' ... message......
		 */
		fprintf(CovFp, "/%s findfont\n", BTFont);		/* set font	*/
		fprintf(CovFp, "3 scalefont setfont\n");		/* and size	*/
		fprintf(CovFp, "880 tmm 20 tmm moveto\n");
		fprintf(CovFp, "(Design: R.M. Bruijne) show\n");

		/*
		 * Do Backcode
		 */
		fprintf(CovFp, "/%s findfont\n", CodeFont);	  /* set font	*/
		fprintf(CovFp, "%d scalefont setfont\n", CodeFSize); /* and size	*/

		if(*(OutC->BackCode) != '\0') {
			fprintf(CovFp, "%d tmm %d tmm moveto\n", CodeXPos, CodeYPos);
			fprintf(CovFp, "(%s) show\n", OutC->BackCode);
		}

		/*
		 * Do Tapetype
		 */
		fprintf(CovFp, "/%s findfont\n", TsNrFont);	  /* set font	*/
		fprintf(CovFp, "%d scalefont setfont\n", TsNrFSize); /* and size	*/
		fprintf(CovFp, "%d tmm %d tmm moveto\n", TsXPos, TsYPos);

		switch(OutC->TapeType) {
		case FEO3:
			fprintf(CovFp, "(I, FERRO) show\n");		/* tapetype	*/
			break;
		case CRO2:
			fprintf(CovFp, "(II, CHROME) show\n");		/* tapetype	*/
			break;
		case FECR:
			fprintf(CovFp, "(III, FERROCHROME) show\n");	/* tapetype	*/
			break;
		case METAL:
			fprintf(CovFp, "(IV, METAL) show\n");		/* tapetype	*/
			break;
		}

		/*
		 * Do Noisereduction
		 */
		fprintf(CovFp, "%d tmm %d tmm moveto\n", NrXPos, NrYPos);
		switch(OutC->NoiseReduction) {
		case DOLBY_B:
			fprintf(CovFp, "(DOLBY B) show\n"); /* noisesys	*/
			break;
		case DOLBY_C:
			fprintf(CovFp, "(DOLBY C) show\n"); /* noisesys	*/
			break;
		case DBX:
			fprintf(CovFp, "(DBX) show\n");     /* noisesys	*/
			break;
		case HXPRO:
			fprintf(CovFp, "(HX-PRO) show\n");  /* noisesys	*/
			break;
		case NO_NR:
			fprintf(CovFp, "(NO NR.) show\n");  /* noisesys	*/
			break;
		}


		/*
		 * Do Backtitles
		 */
		fprintf(CovFp, "/%s findfont\n", BTFont);		/* set font	*/
		fprintf(CovFp, "%d scalefont setfont\n", BTFSize);	/* and size	*/

		if(*(OutC->BackTl1) != '\0') {
			fprintf(CovFp, "%d tmm %d tmm moveto\n", BT1XPos, BT1YPos);
			fprintf(CovFp, "(%s) show\n", OutC->BackTl1);
		}

		if(*(OutC->BackTl2) != '\0') {
			fprintf(CovFp, "%d tmm %d tmm moveto\n", BT2XPos, BT2YPos);
			fprintf(CovFp, "(%s) show\n", OutC->BackTl2);
		}


		/*
		 * Do Side A and side B markers on front of cover
		 */
		fprintf(CovFp, "/%s findfont\n", FrABFont);	  /* set font	*/
		fprintf(CovFp, "%d scalefont setfont\n", FrABFSize); /* and size	*/

		fprintf(CovFp, "%d tmm %d tmm moveto\n", FrAXPos, FrAYPos);
		fprintf(CovFp, "(A) show\n");

		fprintf(CovFp, "%d tmm %d tmm moveto\n", FrBXPos, FrBYPos);
		fprintf(CovFp, "(B) show\n");

		/*
		 * Do backtitles on front of cover
		 */
		fprintf(CovFp, "/%s findfont\n", FrTlFont);	  /* set font	*/
		fprintf(CovFp, "%d scalefont setfont\n", FrTlFSize); /* and size	*/

		if(*(OutC->BackTl1) != '\0') {
			fprintf(CovFp, "%d tmm %d tmm moveto\n", FrTl1XPos, FrTl1YPos);
			fprintf(CovFp, "(%s) show\n", OutC->BackTl1);
		}

		if(*(OutC->BackTl2) != '\0') {
			fprintf(CovFp, "%d tmm %d tmm moveto\n", FrTl2XPos, FrTl2YPos);
			fprintf(CovFp, "(%s) show\n", OutC->BackTl2);
		}

		/*
		 * Now titles of songs
		 */
		fprintf(CovFp, "/%s findfont\n", TlFont);	  	/* set font	*/
		fprintf(CovFp, "%d scalefont setfont\n", TlFSize); /* and size	*/

		/*
		 * SIDE 1
		 */
		SongP = OutC->Side1;
		SongY = Tl1YPos;
		while(SongP != (SONG *)0) {
			if(*(SongP->Count) != '\0') {
				fprintf(CovFp, "%d tmm %d tmm moveto\n", Tl1XPos, SongY);
				fprintf(CovFp, "(%s) show\n", SongP->Count);
			}
			if(*(SongP->Title) != '\0') {
				fprintf(CovFp, "%d tmm %d tmm moveto\n",
											Tl1XPos+CtTlXDist, SongY);
				fprintf(CovFp, "(%s) show\n", SongP->Title);
			}
			SongY -= TlLDist;
			SongP = SongP->Next;
		}

		/*
		 * SIDE 2
		 */
		SongP = OutC->Side2;
		SongY = Tl2YPos;
		while(SongP != (SONG *)0) {
			if(*(SongP->Count) != '\0') {
				fprintf(CovFp, "%d tmm %d tmm moveto\n", Tl2XPos, SongY);
				fprintf(CovFp, "(%s) show\n", SongP->Count);
			}
			if(*(SongP->Title) != '\0') {
				fprintf(CovFp, "%d tmm %d tmm moveto\n",
											Tl2XPos+CtTlXDist, SongY);
				fprintf(CovFp, "(%s) show\n", SongP->Title);
			}
			SongY -= TlLDist;
			SongP = SongP->Next;
		}
		ClearCass(OutC);

	}
	fprintf(CovFp, "showpage\n");
	return;
}
