#include <stdio.h>
#include "xdefs.h"

extern void NoMem();

/*----------------------------------------------*\
 | Allocate space for string s and copy s to	|
 | this space.  Return pointer to new space.	|
\*----------------------------------------------*/
char *
NewString(s)
char *s;
{
	char *NewP;
	char *calloc();

	if((NewP = (char *)calloc(sizeof(char), StringLen(s)+1)) == (char *)0)
		NoMem("NewString");

	StringCopy(s, NewP);
	return(NewP);
}


/*--------------------------------------*\
 | Allocate space for CATITEM struct	|
\*--------------------------------------*/
CATITEM *
NewCatItem()
{
	CATITEM *NewP;
	char    *malloc();

	if((NewP = (CATITEM *)(malloc(sizeof(CATITEM)))) == (CATITEM *)0)
		NoMem("NewCatItem");

	return(NewP);
}



/*------------------------------*\
 | Allocate for new SONG struct	|
\*------------------------------*/
SONG *
NewSong()
{
	SONG *NewP;
	char *malloc();

	if((NewP = (SONG *)malloc(sizeof(SONG))) == (SONG *)0)
		NoMem("NewSong");

	NewP->Status = 0;
	return(NewP);
}





static void
NoMem(Func)
char *Func;
{
	Panic("Out of memory in funtion %s", Func);
}
