#include <stdio.h>
#include "xdefs.h"

/*----------------------------------------------*\
 | Write a filename into buffer FName. A file-	|
 | name is created from a template by incremen-	|
 | ting the last characters of the filename		|
 | until an unused name	is obtained.			|
\*----------------------------------------------*/

static char *Template = "COVERAAA.COV";
/*
 * FIXED denotes the number of chars that do not change
 * NVARS is number of characters that vary.
 */
#define FIXED	5
#define NVARS	3


extern int	FNUsed();
extern int  FNPresent();
extern void FNIncr();

void
MkTmp(FName)
char *FName;
{
	StringCopy(Template, FName);
	while(FNUsed(FName)) {
		FNIncr(FName);
	}
	return;
}

/***************************************************************************/
/*		    ONLY STATIC FUNCTIONS UNDER THIS LINE		   */
/***************************************************************************/



/*
 * Check if an item with filename Name is present.
 * Do this by comparing with all Itemfilenames.
 */
static
FNUsed(Name)
char *Name;
{
	CATITEM *ItPt;
	FILE    *Fp;
	int      Found;

	ItPt  = FirstCatIt;
	Found = 0;
	while(ItPt != (CATITEM *)0 && Found == 0) {
		if(!StringDiff(Name, ItPt->FileName)) {
			Found = 1;
			break;
		}
		ItPt = ItPt->Next;
	}
	if(Found == 0) {
		/*
		 * Filename is not present in the list, but
		 * although the chance is very small there may be
		 * a file with this name by coincidence.
		 * So .. check if it can be opened.
		 */
		if((Fp = fopen(Name, "r")) != NULL) {
			fclose(Fp);
			Found = 1;
		}
	}
	return(Found);
}


void
FNIncr(Name)
char   *Name;
{
	char *Cp;
	int   NChars;

	Cp = Name + FIXED;

	for(NChars = 0; NChars < NVARS; NChars++) {
		if(*Cp == 'Z') {
			*Cp = 'A';
			Cp++;
			continue;
		} else {
			++*Cp;
			return;
		}
	}
	Panic("Too many cassettecovers !!! Delete some!");
	return;
}
