#include <stdio.h>
#include "defines.h"
#include "xdefs.h"


extern void PrintMenu();



/*---------------------------------------------------------------------------*/

MLINE MainItems[] = {
	"Show a list of cassettecovers",		LIST_COVERS,
	"Delete cover(s)",						DEL_COVERS,
	"Create a new cover",					CREAT_COVER,
	"Read in an existing cover",			RD_COVER,
	"Edit a read-in cover",					EDIT_COVER,
	"Show read-in cover on the screen",		SHO_COVER,
	"Print cover(s) to Postscript-file",	FILE_COVER,
	"Quit",									QUIT,
	"",										ENDMARKER
};

MENUITEM MainMenu = {
	"   MAIN MENU - CHOOSE ONE OF THE FOLLOWING OPTIONS:", 0,
	MainItems
};


/*---------------------------------------------------------------------------*/

MLINE TapeItems[] = {
	"I   Ferro (Normal)",			FEO3,
	"II  Chromedioxide (Chromium)",	CRO2,
	"III Ferrochrome",				FECR,
	"IV  Metal",					METAL,
	"",								ENDMARKER
};

MENUITEM TapeMenu = {
	"   TAPE TYPE - CHOOSE A TAPE TYPE", 0,
	TapeItems
};


/*---------------------------------------------------------------------------*/

MLINE NoiseItems[] = {
	"Dolby B",				DOLBY_B,
	"Dolby C",				DOLBY_C,
	"DBX",					DBX,
	"HX-PRO",				HXPRO,
	"No noise reduction",	NO_NR,
	"",						ENDMARKER
};

MENUITEM NoiseMenu = {
	"   NOISE SUPPRESSION - WHICH SYSTEM ?", 0,
	NoiseItems
};

/*---------------------------------------------------------------------------*/




/*--------------*\
 | Print a menu	|
\*--------------*/
static void
PrintMenu(Menu)
MENUITEM *Menu;
{
	MLINE *EntryP;
	int    MCount;

	NLines(SCRLINES - Menu->NEntries*2 - 2);
	printf("%s\n\n", Menu->MenuTitle);

	/*
	 * Print the items of the menu
	 */
	MCount  = 1;
	EntryP  = Menu->Entry;
	while(EntryP->Func != ENDMARKER) {
		printf("\t%2d) %s\n\n", MCount, EntryP->Text);
		EntryP++;
		MCount++;
	}
	printf("   Enter your choice: "); fflush(stdout);
	return;
}




void
InitMenu(Menu)
MENUITEM *Menu;
{
	MLINE    *EntryP;
	int       MCount;

	/*
	 * Count the number of menu items.
	 */
	MCount = 0;
	EntryP  = Menu->Entry;
	while(EntryP++->Func != ENDMARKER)
		MCount++;

	Menu->NEntries = MCount;
	return;
}


ChooseMenu(Menu)
MENUITEM *Menu;
{
	int  Choice;
	char Buf[100];

	do {
		PrintMenu(Menu);
		gets(Buf);
		Choice = atoi(Buf);
	} while(Choice < 1 || Choice > Menu->NEntries);
	return(Menu->Entry[Choice-1].Func);
}
