#include <stdio.h>
#include "defines.h"
#include "xdefs.h"



/*----------------------------------*\
 | Show a list of available covers	|
\*----------------------------------*/
void
ListCovers(Func)
int Func;
{
	CATITEM *It;
	int      NIts;
	int      NLinesThisPage;
	int	     NItsThisPage;
	int      NGroupsPerPage;
	int	     Rest;


	NGroupsPerPage = (SCRLINES-5) / 6;	/* including separation line	*/
	Rest = SCRLINES-5 - NGroupsPerPage*6;

	NLines(3);
	switch(Func) {
	case ALL:
		printf(" LIST OF AVAILABLE COVERS :\n");
		printf("---------------------------\n");
		break;
	case TO_DELETE:
		printf(" LIST OF COVERS TO BE DELETED :\n");
		printf("-------------------------------\n");
		break;
	case TO_PRINT:
		printf(" LIST OF COVERS TO BE PRINTED :\n");
		printf("-------------------------------\n");
		/*
		 * This won't happen, but you may of course add your own code
		 * to support this one.
		 * Then, add an entry in main menu, a case in cas.c
		 * and change output.c to fit your needs.
		 */
		break;
	case TO_FILE:
		printf(" LIST OF COVERS TO BE PRINTED TO DISK :\n");
		printf("---------------------------------------\n");
		break;
	}

	NIts = 0;
	NLinesThisPage = 0;
	NItsThisPage   = 0;

	for(It = FirstCatIt; It != (CATITEM *)0; It = It->Next) {
		if(Func != ALL && !(It->Status & SELECTED))
			continue;

		printf(" %3d) %s\n", NIts+1, It->Description);
		NIts++;
		NLinesThisPage++;
		NItsThisPage++;

		if((NIts % 5) == 0) {
			NLines(1);
			NLinesThisPage++;
		}

		if(NItsThisPage >= NGroupsPerPage*5) {
			/*
			 * new page
			 */
			NLines(Rest+1);
			RetCont();
			NLines(4);
			NLinesThisPage = 0;
			NItsThisPage   = 0;
		}
	}

	NLines(SCRLINES-5 - NLinesThisPage-1);
	return;
}
