#include <stdio.h>
#include "xdefs.h"
#include "defines.h"

extern void DelSongs();
extern void EdSongs();
extern void RmSong();


void
EditCover()
{
	int Choice;
	int Done = 0;


	/*
	 * when no cover is read in, return
	 */
	if(CurIt == (CATITEM *)0) {
		Attention("First read in the cover you wich to edit");
		return;
	}

	while(Done == 0) {
		NLines(SCRLINES - 6 - 13); /* 6 is for ShowGlobal() */
		ShowGlobal(CurIt, CurCass);

		printf("         CHOOSE ONE OF THE FOLLOWING OPTIONS:\n");
		NLines(1);
		printf("     1) Change description\n");
		printf("     2) Change tape type\n");
		printf("     3) Change noise reduction system\n");
		printf("     4) Change back code\n");
		printf("     5) Change back title 1\n");
		printf("     6) Change back title 2\n");
		printf("     7) Edit titles of side 1 and 2\n");
		printf("     8) UNDO all changes\n");
		printf("     9) Return to main menu\n");
		NLines(1);

		printf("    Enter your choice ..."); fflush(stdout);
		gets(Buf);
		Choice = atoi(Buf);

		switch(Choice) {
		case 1:
			InDescription(CurIt);
			break;
		case 2:
			InTapeType();
			break;
		case 3:
			InNoiseRed();
			break;
		case 4:
			InBackCode();
			break;
		case 5:
			InBackTitle(1, &(CurCass->BackTl1));
			break;
		case 6:
			InBackTitle(2, &(CurCass->BackTl2));
			break;
		case 7:
			Done = 1;
			break;
		case 8:
			ClearCass(CurCass);
			ReadCover(CurIt, CurCass);
			break;
		case 9:
			return;
		}
	}

	EdSongs(CurCass, 1);
	EdSongs(CurCass, 2);
	return;
}


static void
EdSongs(Cas, Side)
CASS *Cas;
int   Side;
{
	SONG  *SongP;
	SONG  *Save;
	SONG **List;
	int    Choice;
	int    NSongs;
	int    Num;

	if(Side == 1)
		List = &(Cas->Side1);
	else
		List = &(Cas->Side2);

	while(1) {
		NSongs = CountSongs(*List);

		NLines(SCRLINES - NSongs-1 - 8);
		ShowSongs(*List, Side);
		NLines(1);

		printf(" CHOOSE ONE OF THE FOLLOWING OPTIONS:\n");
		printf("    1) Add a title\n");
		printf("    2) Delete one or more titles\n");
		printf("    3) Change a title\n");
		printf("    4) UNDO changes\n");
		printf("    5) Ready\n");
		printf(" Enter your choice ..."); fflush(stdout);
		gets(Buf);
		Choice = atoi(Buf);

		switch(Choice) {
		case 1:	/* ADD TITLE */
			printf(" After which title (0 for begin) do you want to add\n");
			printf(" the new title ?  ... ");
			fflush(stdout);
			gets(Buf);
			Num = atoi(Buf);

			switch(Num) {
			case 0:
				/*
				 * Put new song at beginning of the list
			 	 */
				Save = *List;
				*List = NewSong();
				(*List)->Next = Save;
				SongP = *List;
				break;
			case 1:
				Save = (*List)->Next;
				SongP = NewSong();
				SongP->Next = Save;
				Save->Next = SongP;
				break;
			default:
				SongP = FindSong(*List, Num);	 /* returns pt to prev it */
				if(SongP == (SONG *)0 || SongP->Next == (SONG *)0) {
					Attention("Title %d does not exist!", Num);
					break;
				}
				SongP = SongP->Next;
				/*
				 * get new SONG struct and insert into the list
				 */
 		        Save = SongP;
				SongP = NewSong();
				SongP->Next = Save->Next;
				Save->Next = SongP;
			}

			NLines(SCRLINES-1);

			/*
			 * Get new counter
			 */
			printf("What is the tape counter reading (max %d character) ? .. ",
												CtLen);
			fflush(stdout);

			gets(Buf);
			NullEnd(Buf, CtLen);
			SongP->Count = NewString(Buf);

			/*
			 * Get new title
			 */
			printf("What is the title (max %d characters) ? .. ", TlLen);
			fflush(stdout);

			gets(Buf);
			NullEnd(Buf, TlLen);
			SongP->Title = NewString(Buf);
			break;

		case 2:	/* DEL TITLE */
			DelSongs(Side);
			break;

		case 3:	/* CHANGE TITLE */
			printf("Which title do you want to change ? ..."); fflush(stdout);
			gets(Buf);
			Num = atoi(Buf);

			if(Num == 0) {
				Attention("Title %d does not exist", Num);
				break;
			}

			if(Num == 1) {
				SongP = *List;
			} else {
				SongP = FindSong(*List, Num);
				if(SongP == (SONG *)0 || SongP->Next == (SONG *)0) {
					Attention("Title %d does not exist", Num);
					break;
				}
				SongP = SongP->Next;
			}

			NLines(SCRLINES-2);
			printf("Old title: %s: %s\n", SongP->Count, SongP->Title);

			free(SongP->Count);
			SongP->Count = (char *)0;
			free(SongP->Title);
			SongP->Title = (char *)0;

			/*
			 * Get new counter
			 */
			printf("What is the new tape counter reading (max %d characters) ? ",
									CtLen);
			fflush(stdout);

			gets(Buf);
			NullEnd(Buf, CtLen);
			SongP->Count = NewString(Buf);

			/*
			 * Get new title
			 */
			printf("What is the new title (max %d characters) ? .. ", TlLen);
			fflush(stdout);

			gets(Buf);
			NullEnd(Buf, TlLen);
			SongP->Title = NewString(Buf);
			break;

		case 4:
			ClearCass(CurCass);
			ReadCover(CurIt, CurCass);
			break;

		case 5:
			return;
		}
	}
}



static void
DelSongs(Side)
int Side;
{
	int    NSongs;
	SONG  *SongP;
	SONG  *Following;
	SONG **List;

	printf(" Specify the titles to be deleted: ");
	fflush(stdout);

	if(Side == 1) {
		List   = &(CurCass->Side1);
		NSongs = CountSongs(*List);
		DoSelect(SONGS1, NSongs);
	} else {
		List   = &(CurCass->Side2);
		NSongs = CountSongs(*List);
		DoSelect(SONGS2, NSongs);
	}

	SongP = *List;
	while(SongP != (SONG *)0) {
		if(SongP->Status & SELECTED) {
			Following = SongP->Next;
			RmSong(SongP, List);
			SongP = Following;
		} else {
			SongP = SongP->Next;
		}
	}
	return;
}


static void
RmSong(SongP, List)
SONG  *SongP;
SONG **List;
{
	SONG  *Prev;
	SONG  *Curr;


	/*
	 * Now delete these songs
	 */
	/*
	 * First item requires special treatment.
	 */
	if(SongP == *List) {
  		*List = (*List)->Next;

		free(SongP->Count);
		SongP->Count = (char *)0;
		free(SongP->Title);
		SongP->Title = (char *)0;
		free(SongP);

		SongP = (SONG *)0;
		return;
	}

	/*
	 * Find 'SongP'
	 */
	Curr = *List;
	while(Curr != SongP) {
		Prev = Curr;
		Curr = Curr->Next;
	}

	/*
	 * Curr points to SongP now.
	 */
	free(Curr->Count);
	Curr->Count = (char *)0;
	free(Curr->Title);
	Curr->Title = (char *)0;

	Prev->Next = Curr->Next;	/* link previous to next item	*/
	free(Curr);
	Curr = (SONG *)0;
	return;
}
