#include <stdio.h>
#include "defines.h"
#include "xdefs.h"


extern void DelSelectedCovers();
extern void DelCatItem();

void
DelCovers()
{
	ListCovers(ALL);

	printf(" Enter the number(s) of the covers to be\n deleted: ");
	fflush(stdout);

	DoSelect(CAT_ITEMS, NCatItems);	/* ask numbers of covers to delete */
	ListCovers(TO_DELETE);

	printf(" Do you really want to remove these covers ? (y/n) ...");
	fflush(stdout);

	if(!Confirm()) {
		UnSelect(CAT_ITEMS);
		return;
	}

	DelSelectedCovers();
	return;
}




/*----------------------------------------------*\
 | Delete all covers in the CATITEM list and	|
 | also delete the files containing the cover	|
 | information.									|
\*----------------------------------------------*/
static void
DelSelectedCovers()
{
	CATITEM *ItPt;
	CATITEM *Save;

	ItPt = FirstCatIt;
	while(ItPt != (CATITEM *)0) {
		Save = ItPt->Next;
		if(ItPt->Status & SELECTED) {
			unlink(ItPt->FileName);
			DelCatItem(ItPt);
		}
		ItPt = Save;
	}
	return;
}


static void
DelCatItem(It)
CATITEM *It;
{
	CATITEM *Prev;
	CATITEM *Curr;

	/*
	 * If the current item is in the delete list, CurIt = 0
	 */
	if(It == CurIt)
		ClearCurr();

	/*
	 * First item requires special treatment.
	 */
	if(It == FirstCatIt) {
		FirstCatIt = It->Next;
		free(It->FileName);
		free(It->Description);
		free(It);
		/*
		 * When we delete last from list (in this case only one),
		 * set LastCatIt as well
		 */
		if(It == LastCatIt)
			LastCatIt = (CATITEM *)0;

		NCatItems--;
		return;
	}

	/*
	 * Find 'It'
	 */
	Curr = FirstCatIt;
	while(Curr != It) {
	Prev = Curr;
		Curr = Curr->Next;
	}

	/*
	 * When this is the last item, make LastCatIt point to Prev
	 * because Prev will be the last one in the list
	 */
	if(LastCatIt == It)
		LastCatIt = Prev;

	/*
	 * Curr points to It now.
	 */
	free(It->FileName);
	free(It->Description);
	Prev->Next = Curr->Next;	/* link previous to next item	*/
	free(It);
	NCatItems--;
	return;
}
