#include <stdio.h>
#include "xdefs.h"
#include "defines.h"


extern void InSongs();
extern void MkTmp();

void
CreatCover()
{
	int CountsWanted = 0;

	ClearCurr();

	CurIt = NewCatItem();
	/*
	 * define a filename for this cover
	 */
	MkTmp(Buf);
	CurIt->FileName    = NewString(Buf);
	CurIt->Description = (char *)0;	/* CurIt was created with malloc() */
	/*
	 * Let char pointers point to empty string
	 */
	CurCass->BackCode = (char *)0;
	CurCass->BackTl1  = (char *)0;
	CurCass->BackTl2  = (char *)0;
	CurCass->Side1    = (SONG *)0;
	CurCass->Side2    = (SONG *)0;

	InDescription(CurIt);
	InTapeType();
	InNoiseRed();
	InBackCode();
	InBackTitle(1, &(CurCass->BackTl1));
	InBackTitle(2, &(CurCass->BackTl2));

	/*
	 * Start inputting songs
	 */
	CountsWanted = AskIfCountsWanted(1);
	InSongs(1, CountsWanted, &(CurCass->Side1));

	CountsWanted = AskIfCountsWanted(2);
	InSongs(2, CountsWanted, &(CurCass->Side2));

	/*
	 * We now entered an entire cassette, so
	 * insert into the catalog and store the cover info in file
	 */
	SaveCover(CurIt, CurCass);
	AddCatItem(CurIt);
	SaveCatalog();
	return;
}



void
InDescription(It)
CATITEM *It;
{
	NLines(SCRLINES - 10);
	printf(" With which text may this cover be saved ?\n");
	NLines(1);
	printf(" This  text is shown in  the  catalogue of\n");
	NLines(1);
	printf(" cassette covers.\n");
	NLines(1);
	printf(" It may not  be longer than 60 characters:\n");
	NLines(3);
	printf("       ............................................................|\n");
	printf(" Text: "); fflush(stdout);

	gets(Buf);
	NullEnd(Buf, 60);

	if(Buf[0] == '\0') {
		StringCopy("There is no describing text with this cover", Buf);
	}

	if(It->Description != (char *)0)	/* In case we are editing ...	*/
		free(It->Description);

	It->Description = NewString(Buf);
	return;
}



void
InTapeType()
{
	int TChoice;

	TChoice = ChooseMenu(&TapeMenu);
	switch(TChoice) {
	case FEO3:
	case CRO2:
	case FECR:
	case METAL:
		CurCass->TapeType = TChoice;
		break;
	default:
		CurCass->TapeType = NONE;
		break;
	}
	return;
}



void
InNoiseRed()
{
	int NChoice;


	NChoice = ChooseMenu(&NoiseMenu);

	switch(NChoice) {
	case DOLBY_B:
	case DOLBY_C:
	case DBX:
	case HXPRO:
	case NO_NR:
		CurCass->NoiseReduction = NChoice;
		break;
	default:
		CurCass->TapeType = NO_NR;
		break;
	}
	return;
}



void
InBackCode()
{
	NLines(SCRLINES - 8);
	printf(" Which code do you want to have printed on the back of\n");
	NLines(1);
	printf(" the cover ? It may not be longer than %d characters :\n", CodeLen);
	NLines(4);
	printf(" Back-code: "); fflush(stdout);

	gets(Buf);
	NullEnd(Buf, CodeLen);
	/*
	 * When we are editing an exisiting cover,
	 * free the previous string
	 */
	if(CurCass->BackCode != (char *)0)
		free(CurCass->BackCode);
	CurCass->BackCode = NewString(Buf);
	return;
}



InBackTitle(Num, BackTl)
int    Num;
char **BackTl;
{
	int i;

	NLines(SCRLINES - 10);
	printf(" Which text do you want to have printed on the back of\n");
	NLines(1);
	printf(" the cover for side %d ?\n", Num);
	NLines(1);
	printf(" This text may not be longer than  %d characters:\n", BTLen);
	NLines(3);
	printf("       ");
	for(i = 0; i < BTLen; i++)
		printf(".");
	printf("\n");

	printf(" Text: "); fflush(stdout);
	
	gets(Buf);
	NullEnd(Buf, BTLen);
	/*
	 * If there is an exisiting backtitle, free it.
	 */
	if(*BackTl != (char *)0)
		free(*BackTl);
	*BackTl = NewString(Buf);
	return;
}




AskIfCountsWanted(Side)
int Side;
{
	printf("\n\n Do you wish to use counter tape numbers for side %d ? (y/n)..",
								Side);
	fflush(stdout);
	return(Confirm());
}






void
InSongs(Side, CountsWanted, SongP)
int    Side;
int    CountsWanted;
SONG **SongP;
{
	char  CountBuf[10];
	int   TCount;
	SONG *New;
	SONG *Curr;

	NLines(SCRLINES-14);
	printf(" Now enter the titles of side %d; hit RETURN when all\n", Side);
	NLines(1);
	printf(" titles of side %d have been entered.\n", Side);
	NLines(1);
	printf(" When there is an error in a title, or you forgot one, just\n");
	NLines(1);
	printf(" continue and later call the EDIT function from the main menu\n");
	NLines(3);

	TCount = 1;

	while(1) {
		if(CountsWanted) {
			printf(" Tape counter reading of title number %d (max %d characters): ",
											TCount, CtLen);
			fflush(stdout);
			gets(CountBuf);
			NullEnd(CountBuf, CtLen);

		if(CountBuf[0] == '\0')	/* prev was last song */
			return;

		}
		printf(" Name of title %2d (max %d chars): ", TCount, TlLen);
		fflush(stdout);
		gets(Buf);
		NullEnd(Buf, TlLen);
		
		if(Buf[0] == '\0')	/* prev was last song */
			return;

		/*
		 * We have a title and maybe a counter
		 * Fill these two in into a new SONG struct
		 */
		New = NewSong();
		if(CountsWanted) {
			New->Count = NewString(CountBuf);
		} else {
			New->Count = NewString("");
		}
		New->Title = NewString(Buf);

		/*
		 * Now add the song struct at the end of the song list
		 */
		New->Next = (SONG *)0;

		if(*SongP == (SONG *)0) {	/* deal separately with first	*/
			*SongP = New;
		} else {
			Curr = *SongP;		/* find end of SONG list	*/
			while(Curr->Next != (SONG *)0)
				Curr = Curr->Next;

			Curr->Next = New;
		}
		TCount++;
	}
}
