#include <stdio.h>
#include "xdefs.h"

#define LINELEN		80
#define CONTMAGIC	"#X-CASS-CATALOG"


extern CATITEM *NewCatItem();



static char    *CassCatalog = "CATALOG.CAS";

void
ReadCatalog()
{
	FILE    *Fp;
	CATITEM *TmpIt;
	int      LineNum;

	if((Fp = fopen(CassCatalog, "r")) == NULL) {
		/*
		 * Catalog file is not there, so no covers are saved yet
		 */
		return;
	}

	LineNum = 0;
	if(CheckMagic(Fp) == -1)
		return;

	LineNum++;

	while(1) {

		/*
		 * Read filename of cassettecover
		 */
		if(fgets(LineBuf, LINELEN-1, Fp) == NULL) {
			/*
			 * No more lines
			 */
			fclose(Fp);
			return;
		}

		TmpIt = NewCatItem();
		LineNum++;
		NullEnd(LineBuf, LINELEN-1);

		/*
		 * Check if legal line
		 */
		if(StringNDiff("#F", LineBuf, 2)) {
			Panic("'#F' expected in catalogue file %s, on line %d",
						CassCatalog, LineNum);
		}
		TmpIt->FileName = NewString(LineBuf+2);		/* +2: skip #F	*/


		/*
		 * Read descriptionline of cassettecover
		 */
		if(fgets(LineBuf, LINELEN-1, Fp) == NULL) {
			Panic("'#D' expected in catalogue file %s, after line %d\n",
							CassCatalog, LineNum);
		}
		LineNum++;
		NullEnd(LineBuf, LINELEN-1);

		/*
		 * Check if legal line
		 */
		if(StringNDiff("#D", LineBuf, 2)) {
			Panic("'#D' expected in catalogue file %s, line %d",
								CassCatalog, LineNum);
		}
		TmpIt->Description = NewString(LineBuf+2);	/* skip #D	*/

		AddCatItem(TmpIt);
	}
}




void
SaveCatalog()
{
	FILE    *Fp;
	CATITEM *It;

	if((Fp = fopen(CassCatalog, "w")) == NULL) {
		/*
	 	 * Catalog file is not there, so no covers are saved yet
		 */
		Panic("Can't write catalogue file %s");
	}

	fprintf(Fp, "%s\n", CONTMAGIC);

	for(It = FirstCatIt; It != (CATITEM *)0; It = It->Next) {
		fprintf(Fp, "#F%s\n", It->FileName);
		fprintf(Fp, "#D%s\n", It->Description);
	}
	fclose(Fp);
	return;
}







/*------------------------------------------------------*\
 | Check if a magic string is in the catalog file	|
\*------------------------------------------------------*/
CheckMagic(Fp)
FILE *Fp;
{

	/*
	 * Read magic of this file
	 */
	if(fgets(LineBuf, LINELEN-1, Fp) == NULL) {
		/*
		 * No information in this file
		 */
		fclose(Fp);
		return(-1);
	}

	NullEnd(LineBuf, LINELEN-1);

	if(StringDiff(LineBuf, CONTMAGIC)) {
		fclose(Fp);
		Panic("File %s is not a cover catalogue file!", CassCatalog);
	}
	return(0);
}






/*----------------------------------------------*\
 | Add a catalog item at the end of the list	|
\*----------------------------------------------*/
void
AddCatItem(It)
CATITEM *It;
{
	It->Next   = (CATITEM *)0;	/* It always added at the end	*/
	It->Status = (flag)0;

	/*
	 * Is it the first item ?
	 */
	if(FirstCatIt == (CATITEM *)0) {
		FirstCatIt = It;
		LastCatIt  = It;
		NCatItems  = 1;
		return;
	}

	/*
	 * Insert It at the end of the list
	 */
	if(LastCatIt == (CATITEM *)0) {
		Panic("LastCatIt == 0");
	}
	LastCatIt->Next = It;
	LastCatIt = It;
	NCatItems++;
	return;
}
