#include "defines.h"
#include "xdefs.h"

/*----------------------------------*\
 | Program to create cassettecovers	|
 | via interactive menus.			|
 | Put TABs in every 4th position	|
 | vi: ':set ts=4<CR>'				|
 | 									|
 | 		Remco Bruyne				|
\*----------------------------------*/

extern void StartMesg();
extern void Clearup();
extern void ReadCatalog();
extern void CreatCover();
extern void DelCovers();
extern void EditCover();
extern void InitMenu();
extern void OutCovers();
extern void ReadACover();
extern void ShowCover();


main()
{
	/*
	 * Init menus. This is for counting the number of items
	 */
	InitMenu(&MainMenu);
	InitMenu(&TapeMenu);
	InitMenu(&NoiseMenu);
	InitParams();

#ifdef ATARI
	ClearScreen();
#endif /* ATARI */
	ClearScreen();
	StartMesg();

	ReadCatalog();

	while(1) {
		switch(ChooseMenu(&MainMenu)) {
		case LIST_COVERS:
			if(NCatItems == 0) {
				Attention("There are no covers available yet");
				continue;
			}
			ListCovers(ALL);
			RetCont();
			break;

		case DEL_COVERS:
			if(NCatItems == 0) {
				Attention("There are no covers available yet");
				continue;
			}
			DelCovers();
			break;

		case CREAT_COVER:
			CreatCover();
			break;

		case RD_COVER:
			ReadACover();
			break;

		case EDIT_COVER:
			EditCover();
			SaveCover(CurIt, CurCass);
			SaveCatalog();
			break;

		case SHO_COVER:
			ShowCover();
			break;

		case FILE_COVER:
			if(NCatItems == 0) {
				Attention("There are no covers available yet");
				continue;
			}
			OutCovers(TO_FILE);
			break;

		case QUIT:
			Clearup();
			return(0);
		}
	}
}



void
Clearup()
{
	SaveCatalog();
	return;
}



void
StartMesg()
{
printf("             *-------------------------------------*\n");
printf("             |                                     |\n");
printf("             |               CASSCOVER             |\n");
printf("             |                                     |\n");
printf("             *-------------------------------------*\n\n");

printf("            A PROGRAM FOR MAKING CASSETTE TAPE COVERS\n\n");

printf("                         by R.M. Bruijne ..\n");
NLines((SCRLINES-9)/2 - 4);
printf("                This is a PUBLIC DOMAIN program!\n\n\n\n");
RetCont();

NLines(SCRLINES-8);
printf("CASSCOVER may be copied freely, but NOT for commercial purposes.\n\n");

printf("This program runs under all versions of UN*X,  under VAX/VMS, on\n");
printf("all MS-DOS machines, on ATARI ST and on some other systems.\n\n");

printf("There are no known bugs as yet (jan 1990),but when you find any,\n");
printf("please report them to the author: remco@tnoibbc.ibbc.tno.nl.\n\n");

printf("The file CASSETTE.DAT is a configuration file.  In this file you\n");
printf("find the fonts, character sizes and the positioning of all texts\n");
printf("and separation lines. See also the supplied documentation.\n\n");

NLines(SCRLINES-17);
RetCont();
return;
}
