/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Lawrence Berkeley Laboratory,
 * Berkeley, CA.  The name of the University may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * @(#) $Header: tcpgram.h,v 1.1 90/01/12 14:38:24 mccanne Exp $ (LBL)
 */


/*
 * This is the structure used to keep track of the backpatching that
 * needs to be done during the parse.  Each field is an index into
 * the code array.  OP points to the most recently generated insn
 * of the group (by group I mean the set of insns that represent
 * a given expression).  F points to the list of insns such that
 * if any insn in this list evaluates to false, the entire expression is
 * false; T is analogous to F but for true results.   These lists
 * are implemented via links in the jump field of the insns.  
 */
struct blist { int op, f, t; };

/*
 * To support arbitrary subnets, network address comparison is done
 * via a mask.  Currently, arbitrary masks are not supported and
 * the mask is automatically computed by byte-aligning it with the
 * network number that INET_NETWORK returns.
 */
struct net_id {
	unsigned long n;	/* internet address */
	unsigned long m;	/* comparison mask */
};

/*
 * A union encompassing all possible types of identifiers that
 * the scanner might look up for the parser.  This is part of YYSTYPE.
 */
union id {
	struct net_id n;		/* network address and mask */
	unsigned long h;		/* host address */
	struct ether_addr *e;		/* ethernet address */
	int pr;				/* protocol */
	struct { int pt; int pr; } pp;	/* port and its protocol */
	struct {			/* gateway */
		struct ether_addr *e;
		unsigned long h;
	} g;
};

/*
 * Number of errors detected during then parse and scan.
 */
extern int n_errors;
