/*
 * Copyright (c) 1989 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Lawrence Berkeley Laboratory,
 * Berkeley, CA.  The name of the University may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
#ifndef lint
static  char rcsid[] =
	"@(#)$Header: sl_print.c,v 1.5 90/01/12 16:36:25 mccanne Exp $ (LBL)";
#endif

#ifdef CSLIP
#include <stdio.h>
#include <netdb.h>
#include <ctype.h>
#include <signal.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/timeb.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <sys/mbuf.h>
#include <sys/ioctl.h>
#include <net/nit.h>

#ifdef SUNOS4
#include <sys/dir.h>
#include <net/nit_if.h>
#include <net/nit_pf.h>
#include <net/nit_buf.h>
#include <sys/stropts.h>
#endif

#include <net/if.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/if_ether.h>
#include <netinet/ip_var.h>
#include <netinet/udp.h>
#include <netinet/udp_var.h>
#include <netinet/tcp.h>
#include <netinet/tcpip.h>

#include <net/slcompress.h>

#ifdef SUNOS4
#include "sunos4.map.h"
#endif

#include "interface.h"
#include "netstrings.h"
#include "sample.h"

extern char *timestamp_fmt;
extern long timestamp_scale;
extern int thiszone;

static int lastlen[2][256];
static int lastconn = 255;

static void compressed_sl_print();

void
sl_if_print(sp, nh)
	u_char *sp;
	register struct nit_hdr *nh;
{
	int length;
	register int i;
	struct in_addr inet_makeaddr();
	struct ip *ip;
	int dir;

	if (tflag) {
		i = (nh->nh_timestamp.tv_sec + thiszone) % 86400;
		(void)printf (timestamp_fmt,
			i / 3600, (i % 3600) / 60, i % 60,
			nh->nh_timestamp.tv_usec / timestamp_scale);
	}
	length = nh->nh_wirelen - sizeof (struct ether_header);
	dir = *((u_char *)sp) == 2;
	i = TYPE(sp);
	switch (i & 0xf0) {

	case 0x40:
		ip_print(Ip(sp), length);
		break;

	case 0x70:
		ip = Ip(sp); 
		lastconn = ip->ip_p;
		ip->ip_p = IPPROTO_TCP;
		i = ip->ip_hl;
		i += ((struct tcphdr *)&((int *)ip)[i])->th_off;
		lastlen[dir][lastconn] = length - (i << 2);
		ip_print(ip, length);
		printf("(%s C#%d)", dir? "R > L" : "L > R", lastconn);
		break;

	default:
		if (i & 0x80) {
			u_char *cp = (u_char *)sp + sizeof(struct ether_header);

			compressed_sl_print(cp, length, dir);
		} else if (! xflag)
			default_print((u_short *)(sp + sizeof (struct ether_header)), length);
		break;
	}
	if (xflag)
		default_print((u_short *)(sp + sizeof (struct ether_header)),
			      length);
	putchar ('\n');
}

static u_char *
print_sl_change(str, cp)
	char *str;
	register u_char *cp;
{
	register u_int i;

	if ((i = *cp++) == 0) {
		i = (cp[0] << 8) | cp[1];
		cp += 2;
	}
	printf(" %s%d", str, i);
	return (cp);
}

static u_char *
print_sl_winchange(cp)
	register u_char *cp;
{
	register short i;

	if ((i = *cp++) == 0) {
		i = (cp[0] << 8) | cp[1];
		cp += 2;
	}
	if (i >= 0)
		printf(" W+%d", i);
	else
		printf(" W%d", i);
	return (cp);
}

static void
compressed_sl_print(pp, length, dir)
	u_char *pp;
	int length;
	int dir;
{
	register u_char *cp = pp;
	register u_int flags;
	int hlen;

	printf(dir? "R > L" : "L > R");
	flags = *cp++;
	if (flags & NEW_C) {
		lastconn = *cp++;
		printf(" ctcp %2d: ", lastconn);
	} else
		printf(" ctcp (%2d): ", lastconn);

	printf("%c", flags & TCP_PUSH_BIT ? 'P':'-');
	cp += 2;	/* skip tcp checksum */

	switch (flags & SPECIALS_MASK) {
	case SPECIAL_I:
		printf(" SA*+%d", lastlen[dir][lastconn]);
		break;
	case SPECIAL_D:
		printf(" S*+%d", lastlen[dir][lastconn]);
		break;
	default:
		if (flags & NEW_U)
			cp = print_sl_change("U=", cp);
		if (flags & NEW_W)
			cp = print_sl_winchange(cp);
		if (flags & NEW_A)
			cp = print_sl_change("A+", cp);
		if (flags & NEW_S)
			cp = print_sl_change("S+", cp);
		break;
	}
	if (flags & NEW_I)
		cp = print_sl_change("I+", cp);

	hlen = cp - pp;
	lastlen[dir][lastconn] = length - hlen;
	printf(" %d (%d)", lastlen[dir][lastconn], hlen);
}
#endif
