/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Lawrence Berkeley Laboratory,
 * Berkeley, CA.  The name of the University may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

/*
 * Name to id translation routines used by the scanner.
 * These functions are not time critical.
 */

#ifndef lint
static char rcsid[] =
    "@(#) $Header: pstr.c,v 1.1 89/06/24 23:33:00 mccanne Exp $ (LBL)";
#endif

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netdb.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <arpa/inet.h>

#include "interface.h"

struct ether_addr *ether_aton();

/*
 *  Convert host name to internet address.
 *  Return 0 upon failure.
 */
unsigned long
s_nametoaddr(name)
	char *name;
{
	struct hostent *hp;

	if (hp = gethostbyname(name))
		return (unsigned long) (*(int *)hp->h_addr);
	else 
		return 0L;
}


/*
 *  Convert net name to internet address.
 *  Return 0 upon failure.
 */
unsigned long
s_nametonetaddr(name)
	char *name;
{
	struct netent *np;

	if (np = getnetbyname(name))
		return (unsigned long) (np->n_net);
	else 
		return 0L;
}

/*
 *  Convert a name to an etheraddr struct.
 *  Return 0 upon failure.
 */
struct ether_addr *
s_nametoeaddr(name)
	char *name;
{
	struct ether_addr *p;

	p = (struct ether_addr *) malloc(sizeof(*p));
	if (ether_hostton (name, p)) 
		return (struct ether_addr *) 0;
	else 
		return p;
}


/*
 *  Convert an ethernet number string to an etheraddr struct.
 *  Return 0 upon failure.
 */
struct ether_addr *
s_numstrtoeaddr(str)
	char *str;
{
	struct ether_addr *p, *t;

	p = (struct ether_addr *) malloc(sizeof(*p));
	if (! (t = ether_aton(str))) {
		fprintf (stderr, "illegal ethernet address: %s\n", str);
		exit (1);
	}
	bcopy (t, p, sizeof(*p));
	return p;
}

/*
 *  Convert a port name to its port and protocol numbers.
 *  Return 0 upon failure.
 */
s_nametoport(str, p)
	char *str;
	struct { int pt, pr; } *p;
{
	struct servent *sp;

	if (sp = getservbyname(str, (char *)NULL)) {
		p->pt = sp->s_port;
		p->pr = s_nametoproto(sp->s_proto);
		return TRUE;
	}
	else
		return 0;
}

int
s_nametoproto (str)
	char *str;
{
	struct protoent *p;
       
	p = getprotobyname (str);

	if (p)
		return p->p_proto;
	else
		return -1;
}

int 
s_nametoeproto (s)
	char *s;
{
	int i;

	static struct { char *s; int p; } tab[] = { 
		{ "pup", ETHERTYPE_PUP },
		{ "ip", ETHERTYPE_IP },
		{ "arp", ETHERTYPE_ARP },
		{ "rarp", ETHERTYPE_REVARP },
		{ (char *)0, 0 }
	};
	for (i = 0; tab[i].s; i++)
		if (strcmp (tab[i].s, s) == 0)
			return tab[i].p;
	return -1;
}
