/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Lawrence Berkeley Laboratory,
 * Berkeley, CA.  The name of the University may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
#ifndef lint
static  char rcsid[] =
	"@(#)$Header: initdevice.c,v 1.2 89/06/26 18:02:19 leres Exp $ (LBL)";
static char copyright[] =
	"Copyright (C) 1987, Van Jacobson, Lawrence Berkeley Laboratory";
#endif

#include <sys/types.h>
#include <sys/time.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/nit.h>

#ifdef SUNOS4
#include <sys/dir.h>
#include <net/nit_if.h>
#include <net/nit_pf.h>
#include <net/nit_buf.h>
#include <sys/stropts.h>
#include <net/if.h>
#include <sys/fcntlcom.h>
#endif


#ifndef SUNOS4
int
initdevice (device, pflag, bufspace, chunksize, snaplen)
	char *device;
	int pflag, bufspace, chunksize, snaplen;
{
	struct sockaddr_nit snit;
	struct nit_ioc nioc;
	int if_fd;

	if_fd = socket(AF_NIT, SOCK_RAW, NITPROTO_RAW);

	if (if_fd < 0) {
		perror("nit socket");
		exit(-1);
	}

	snit.snit_family = AF_NIT;
	if (device) {
		(void)strncpy(snit.snit_ifname, device, NITIFSIZ);
		if (bind(if_fd, (struct sockaddr *)&snit, sizeof(snit))) {
			perror(device);
			exit (1);
		}
	} else {
		/* if no interface, try le0 then ie0 */
		(void)strncpy(snit.snit_ifname, "le0", NITIFSIZ);
		if (bind(if_fd, (struct sockaddr *)&snit, sizeof(snit))) {
			if (errno != EADDRNOTAVAIL) {
				perror ("le0");
				exit (1);
			}
			(void)strncpy(snit.snit_ifname, "ie0", NITIFSIZ);
			if (bind(if_fd, (struct sockaddr *)&snit, sizeof(snit))) {
				perror("le0 or ie0");
				exit (1);
			}
		}
	}
	bzero((char *)&nioc, sizeof(nioc));
	nioc.nioc_bufspace = bufspace;
	nioc.nioc_chunksize = chunksize;
	nioc.nioc_typetomatch = NT_ALLTYPES;
	nioc.nioc_snaplen = snaplen;
	nioc.nioc_bufalign = sizeof (int);
	nioc.nioc_bufoffset = 0;
	nioc.nioc_flags = pflag ? NF_TIMEOUT : NF_PROMISC|NF_TIMEOUT;
	nioc.nioc_timeout.tv_sec = 1;
	nioc.nioc_timeout.tv_usec = 0;

	if (ioctl(if_fd, SIOCSNIT, &nioc) != 0) {
		perror("nit ioctl");
		exit(1);
	}
	return if_fd;
}
#else
int
initdevice (device, pflag, bufspace, chunksize, snaplen)
	char *device;
	int pflag, bufspace, chunksize, snaplen;
{
	struct strioctl si;		/* struct for ioctl() */
	struct timeval timeout;		/* timeout for ioctl() */
	struct ifreq ifr;		/* interface request struct */
	u_long if_flags;		/* modes for interface             */
	int  ret;
	int if_fd;

	if ((if_fd = open("/dev/nit",O_RDONLY)) < 0) {
		perror("nit_open");
		exit(-1);
	}

	/* arrange to get discrete messages from the STREAM and use NIT_BUF */
	ioctl(if_fd, I_SRDOPT, (char*)RMSGD);
	ioctl(if_fd, I_PUSH, "nbuf");

	/* set the timeout */
	si.ic_timout = INFTIM;
	timeout.tv_sec = 1;
	timeout.tv_usec = 0;
	si.ic_cmd = NIOCSTIME;
	si.ic_len = sizeof(timeout);
	si.ic_dp = (char*)&timeout;
	if ((ret = ioctl(if_fd, I_STR, (char*)&si)) < 0) {
		perror("nit_ioctl_timeout");
		exit(-1);
	}

	/* set the chunksize */
	si.ic_cmd = NIOCSCHUNK;
	si.ic_len = sizeof(chunksize);
	si.ic_dp = (char*)&chunksize;
	if ((ret = ioctl(if_fd, I_STR, (char*)&si)) < 0) {
		perror("nit_ioctl_chunksize");
		exit(-1);
	}

	/* request the interface */
	if (device) {
		strncpy(ifr.ifr_name, device, sizeof(ifr.ifr_name));
		ifr.ifr_name[sizeof(ifr.ifr_name) - 1] = ' ';
		si.ic_cmd = NIOCBIND;
		si.ic_len = sizeof(ifr);
		si.ic_dp = (char*)&ifr;
		if ((ret = ioctl(if_fd, I_STR, (char*)&si)) < 0) {
			perror(device);
			exit(1);
		}
	} else {
		strncpy(ifr.ifr_name, "le0", sizeof(ifr.ifr_name));
		ifr.ifr_name[sizeof(ifr.ifr_name) - 1] = ' ';
		si.ic_cmd = NIOCBIND;
		si.ic_len = sizeof(ifr);
		si.ic_dp = (char*)&ifr;
		if ((ret = ioctl(if_fd, I_STR, (char*)&si)) < 0) {
			if (errno != ENXIO) {
				perror("le0");
				exit(1);
			} else {
				strncpy(ifr.ifr_name, "ie0",
					sizeof(ifr.ifr_name));
				ifr.ifr_name[sizeof(ifr.ifr_name) - 1] = ' ';
				si.ic_cmd = NIOCBIND;
				si.ic_len = sizeof(ifr);
				si.ic_dp = (char*)&ifr;
				if ((ret = ioctl(if_fd, I_STR, (char*)&si)) < 0) {
					perror("le0 or ie0");
					exit(1);
				}
			}
		}
	}

	/* set the snapshot length */
	si.ic_cmd = NIOCSSNAP;
	si.ic_len = sizeof(snaplen);
	si.ic_dp = (char*)&snaplen;
	if ((ret = ioctl(if_fd, I_STR, (char*)&si)) < 0) {
		perror("nit_ioctl_snaplen");
		exit(1);
	}

	/* set the interface flags */
	si.ic_cmd = NIOCSFLAGS;
	if_flags = pflag ?
		NI_TIMESTAMP | NI_LEN : NI_TIMESTAMP | NI_PROMISC | NI_LEN;
	si.ic_len = sizeof(if_flags);
	si.ic_dp = (char*)&if_flags;
	if ((ret = ioctl(if_fd, I_STR, (char*)&si)) < 0) {
		perror("nit_ioctl_iflags");
		exit(1);
	}
	ioctl(if_fd, I_FLUSH, (char*)FLUSHR);

	return if_fd;
}
#endif

