/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Lawrence Berkeley Laboratory,
 * Berkeley, CA.  The name of the University may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */
#ifndef lint
static char rcsid[] =
    "@(#) $Header: filter.c,v 1.3 90/01/13 17:42:01 mccanne Exp $ (LBL)";
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netinet/udp.h>
#include <netinet/udp_var.h>
#include <netinet/tcp.h>
#include <netinet/tcpip.h>

#ifdef SUNOS4
#include "sunos4.map.h"
#endif

#include "sample.h"
#include "interface.h"
#include "filter.h"

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#ifdef __GNUC__
#define CAT(a,b)	a ## b
#else
#define IDENT(x)	x
#define CAT(a,b)	IDENT(a)b
#endif
/*
 * These definitions handle the comparisons for the filter code interpreter.
 * For machines sensitive to alignment, the comparisons are done two
 * bytes at a time.  This will work as long as the data types appear at
 * even addresses. 
 */
#ifndef ALIGN
#define Compare4(p1,p2)	(*(u_int *)(p1) == *(u_int *)(p2))
#else
#define Compare4(p1,p2)	(*(u_short *)(p1) == *(u_short *)(p2) &&\
			 *((u_short *)(p1)+1) == *((u_short *)(p2)+1))
#endif

/*
 * Same as above but with a mask. (for nets)
 */
#ifndef ALIGN
#define Compare4m(p1,p2,m)	(*(u_int *)(p1) == (*(u_int *)(p2) & (m)))
#else
#define Compare4m(p1,p2,m)	(*(u_short *)(p1) == \
				 (*(u_short *)(p2) & (u_short)((m) >> 16)) &&\
				 *((u_short *)(p1)+1) ==\
				 (*((u_short *)(p2)+1) & (u_short)(m)))
#endif

#define Compare2(p1,p2)		(*(u_short *)(p1) == (*(u_short *)(p2)))


#ifdef ALIGN
#define EXTRACT_SHORT(p)	((short)(((*((char *)(p)))<<8)|\
					 (*(((char *)(p))+1))))
#else
#define EXTRACT_SHORT(p)	(*(short *)p)
#endif

#ifdef ALIGN
#define EXTRACT_INT(p)		((EXTRACT_SHORT(p))|\
				 (EXTRACT_SHORT(((char *)p)+2)))
#else
#define EXTRACT_INT(p)		(*(int *)p)
#endif

int
execute (sp, length, pc)
	register struct ether_header *sp; 	/* the packet */
	register struct insn *pc;	/* filter code "program counter" */
{
	register int r0, r1, r2;

	while (1) {

		switch (pc->opcode) {
			
		default: 
			punt ("illegal opcode in execute");
			
		case AcceptOp:
			return TRUE;
			
		case RejectOp:
			return FALSE;

		case IpDstOp:
			(int *)pc += Compare4 (&pc->data[0], &Ip(sp)->ip_dst)?
				pc->jt : pc->jf;
			continue;

		case IpSrcOp:
			(int *)pc += Compare4 (&pc->data[0], &Ip(sp)->ip_src)?
				pc->jt : pc->jf;
			continue;

		case IpDstNetOp: 
			(int *)pc += Compare4m (&pc->data[0], &Ip(sp)->ip_dst,
						pc->data[1])?
							pc->jt : pc->jf;
			continue;
			
		case IpSrcNetOp:
			(int *)pc += Compare4m (&pc->data[0], &Ip(sp)->ip_src,
						pc->data[1])?
							pc->jt : pc->jf;
			continue;
			
		case RarpDstOp:
		case ArpDstOp:
			(int *)pc += Compare4 (&pc->data[0], 
					       Arp (sp)->arp_xtpa)?
						       pc->jt : pc->jf;
			continue;

		case RarpSrcOp:
		case ArpSrcOp:
			(int *)pc += Compare4 (&pc->data[0],
					       Arp (sp)->arp_xspa)?
						       pc->jt : pc->jf;
			continue;

		case RarpDstNetOp:
		case ArpDstNetOp:
			(int *)pc += Compare4m (&pc->data[0],
						Arp (sp)->arp_xtpa,
						pc->data[1])?
							pc->jt : pc->jf;
			continue;

		case RarpSrcNetOp:
		case ArpSrcNetOp:
			(int *)pc += Compare4m (&pc->data[0],
						Arp (sp)->arp_xspa,
						pc->data[1])?
							pc->jt : pc->jf;
			continue;

		case EDstOp:
			(int *)pc += Compare4 (&pc->data[0], 
					       &sp->ether_dhost)
				&& Compare2 (&pc->aux,
					     (int *)&sp->ether_dhost + 1) ?
						     pc->jt : pc->jf;
			continue;
			
		case ESrcOp:
			(int *)pc += Compare4 (&pc->data[0],
					       &sp->ether_shost)
				&& Compare2 (&pc->aux, 
					     (int *)&sp->ether_shost + 1)?
						     pc->jt : pc->jf;
			continue;
			
		case UdpDstPortOp:
			(int *)pc += (pc->aux == UdpIp (sp)->uh_dport)?
				pc->jt : pc->jf;
			continue;
			
		case UdpSrcPortOp:
			(int *)pc += (pc->aux == UdpIp (sp)->uh_sport)?
				pc->jt : pc->jf;
			continue;

		case TcpDstPortOp:
			(int *)pc += (pc->aux == TcpIp (sp)->th_dport)?
				pc->jt : pc->jf;
			continue;

		case TcpSrcPortOp:
			(int *)pc += (pc->aux == TcpIp (sp)->th_sport)?
				pc->jt : pc->jf;
			continue;

		case LessOp:
			(int *)pc += (length <= pc->aux) ? pc->jt : pc->jf;
			continue;

		case GreaterOp:
			(int *)pc += (length >= pc->aux) ? pc->jt : pc->jf;
			continue;
			
		case IpProtoOp:
			(int *)pc += (pc->aux == Ip (sp)->ip_p)?
				pc->jt : pc->jf;
			continue;
			
		case AndByteOp:
			(int *)pc += (((char *)sp)[pc->data[0]] & pc->aux)?
				pc->jt : pc->jf;
			continue;

		case OrByteOp:
			(int *)pc += (((char *)sp)[pc->data[0]] | pc->aux)?
				pc->jt : pc->jf;
			continue;

		case EqByteOp:
			(int *)pc += (((char *)sp)[pc->data[0]] == pc->aux)?
				pc->jt : pc->jf;
			continue;

		case LTByteOp:
			(int *)pc += (((char *)sp)[pc->data[0]] < (char)pc->aux)?
				pc->jt : pc->jf;
			continue;

		case GTByteOp:
			(int *)pc += (((char *)sp)[pc->data[0]] > (char)pc->aux)?
				pc->jt : pc->jf;
			continue;

		case EtherProtoOp:
			(int *)pc += (TYPE (sp) == pc->aux)?
				pc->jt : pc->jf;
			continue;
			
#define CASE(op, code)\
		case CAT(op,Op_0): \
			(int *)pc += r0 code r1 ? pc->jt : pc->jf;\
			continue;\
		case CAT(op,Op_1):\
			(int *)pc += r0 code r2 ? pc->jt : pc->jf;\
			continue;\
		case CAT(op,Op_2):\
			(int *)pc += r1 code r0 ? pc->jt : pc->jf;\
			continue;\
		case CAT(op,Op_3):\
			(int *)pc += r1 code r2 ? pc->jt : pc->jf;\
			continue;\
		case CAT(op,Op_4):\
			(int *)pc += r2 code r0 ? pc->jt : pc->jf;\
			continue;\
		case CAT(op,Op_5):\
			(int *)pc += r2 code r1 ? pc->jt : pc->jf;\
			continue;

		CASE (GT, >)
		CASE (GE, >=)
		CASE (LT, <)
		CASE (LE, <=)
		CASE (EQ, ==)
		CASE (NE, !=)

#undef CASE
#define CASE(op, code)\
		case CAT(op,Op_0): \
			r0 CAT (code,=) r1; break;\
		case CAT(op,Op_1):\
			r0 CAT (code,=) r2; break;\
		case CAT(op,Op_2):\
			r1 CAT (code,=) r0; break;\
		case CAT(op,Op_3):\
			r1 CAT (code,=) r2; break;\
		case CAT(op,Op_4):\
			r2 CAT (code,=) r0; break;\
		case CAT(op,Op_5):\
			r2 CAT (code,=) r1; break;

		CASE (Add, +)
		CASE (Sub, -)
		CASE (Mul, *)
		CASE (And, &)
		CASE (Or, |)

		case DivOp_0:
			if (r1) r0 /= r1; break;
		case DivOp_1:
			if (r2) r0 /= r2; break;
		case DivOp_2:
			if (r0) r1 /= r0; break;
		case DivOp_3:
			if (r2) r1 /= r2; break;
		case DivOp_4:
			if (r0) r2 /= r0; break;
		case DivOp_5:
			if (r1) r2 /= r1; break;

		case LoadImmOp_0:
			r0 = pc->data[0];
			break;
			
		case LoadImmOp_1:
			r1 = pc->data[0];
			break;
			
		case LoadImmOp_2:
			r2 = pc->data[0];
			break;
			
#undef CASE
#define CASE(op, addr)\
		case CAT(op,Op_0):\
			if (r0 < length) {\
				switch (pc->aux) {\
				case sizeof (int):\
					r0 = EXTRACT_INT (&((char *)addr)[r0]);\
					break;\
\
				case sizeof (short):\
					r0 = EXTRACT_SHORT (&((char *)addr)[r0]);\
					break;\
\
				default:\
					r0 = ((char *)addr)[r0];\
				}\
			}\
			break;\
		case CAT(op,Op_1):\
			if (r1 < length) {\
				switch (pc->aux) {\
				case sizeof (int):\
					r1 = EXTRACT_INT (&((char *)addr)[r1]);\
					break;\
\
				case sizeof (short):\
					r1 = EXTRACT_SHORT (&((char *)addr)[r1]);\
					break;\
\
				default:\
					r1 = ((char *)addr)[r1];\
				}\
			}\
			break;\
		case CAT(op,Op_2):\
			if (r2 < length) {\
				switch (pc->aux) {\
				case sizeof (int):\
					r2 = EXTRACT_INT (&((char *)addr)[r2]);\
					break;\
\
				case sizeof (short):\
					r2 = EXTRACT_SHORT (&((char *)addr)[r2]);\
					break;\
\
				default:\
					r2 = ((char *)addr)[r2];\
				}\
			}\
			break;

		CASE (LoadEther, sp)
		CASE (LoadIp, Ip (sp))
		CASE (LoadArp, Arp (sp))
		CASE (LoadRarp, Arp (sp))
		CASE (LoadTcp, TcpIp (sp))
		CASE (LoadUdp, UdpIp (sp))
		}
		(int *) pc += insn_size[pc->opcode];
	}
}
