/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Lawrence Berkeley Laboratory,
 * Berkeley, CA.  The name of the University may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
#ifndef lint
static char rcsid[] =
    "@(#) $Header: debug.c,v 1.6 90/01/12 18:09:03 mccanne Exp $ (LBL)";
#endif

#include "interface.h"
#include "filter.h"
#include "tcpgram.h"
#include "tokdefs.h"

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netdb.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>

#ifdef SUNOS4
#include "sunos4.map.h"
#endif

extern char *opstrings[];

static char *
d_getename (e)
	struct ether_addr *e;
{
	char *ether_ntoa ();
	static char buf[100];

	if (ether_ntohost (buf, e))
		return ether_ntoa (e);
	else
		return buf;
}

static char *
d_getname (addr)
	int addr;
{
	char *inet_ntoa ();
	register struct hostent *hp;

	hp = gethostbyaddr ((char *)&addr, sizeof (int), AF_INET);

	if (hp)
		return hp->h_name;
	{
		/*
		 * This is a roundabout way of passing an int to INET_NTOA, 
		 * but a good optimizer fixes it.
		 */
		struct in_addr s;

		s.s_addr = addr;
		return inet_ntoa (s);
	}
}

static void
show_op (insn, i)
	struct insn *insn;
	int i;
{
	int jump = 1;
	char operand[80];

	union {
		struct protoent *proto;
		struct servent *serv;
		struct in_addr addr;
	} st;

	struct ether_addr e;

	printf ("(% 3d)  %-20s", i, opstrings[insn->opcode]);

	switch (insn->opcode) {
	default:
		punt ("\nbad opcode in show_op\n");
		break;

	case IpDstOp:
	case IpSrcOp:
	case ArpDstOp:
	case ArpSrcOp:
	case RarpDstOp:
	case RarpSrcOp:
		strcpy (operand, d_getname (insn->data[0]));
		break;

	case EDstOp:
	case ESrcOp:
		bcopy (&insn->data[0], &e, 4);
		bcopy (&insn->aux, ((char *)&e)+4, 2);
		strcpy (operand, d_getename (&e));
		break;

	case IpDstNetOp:
	case IpSrcNetOp:
	case ArpDstNetOp:
	case ArpSrcNetOp:
	case RarpDstNetOp:
	case RarpSrcNetOp:
		strcpy (operand, inet_ntoa (insn->data[0]));
/*		printf (" (mask: %s)", inet_ntoa (insn->data[1])); */
		break;

	case TcpDstPortOp:
	case TcpSrcPortOp:
		st.serv = getservbyport (insn->aux, "tcp");
		if (st.serv)
			strcpy (operand, st.serv->s_name);
		else
			sprintf (operand, "%d", insn->aux);
		break;

	case UdpDstPortOp:
	case UdpSrcPortOp:
		st.serv = getservbyport (insn->aux, "udp");
		if (st.serv)
			strcpy (operand, st.serv->s_name);
		else
			strcpy (operand, insn->aux);
		break;

	case LessOp:
	case GreaterOp:
		sprintf (operand, "%d", insn->aux);
		break;

	case IpProtoOp:
		st.proto = getprotobynumber (insn->aux);
		strcpy (operand, st.proto ? st.proto->p_name : "?");
		break;

	case AndByteOp:
	case OrByteOp:
	case EqByteOp:
	case LTByteOp:
	case GTByteOp:
		sprintf (operand, "%d %d", insn->data[0], insn->aux);
		break;

	case EtherProtoOp:
		switch (insn->aux) {
		case ETHERPUP_IPTYPE:
			strcpy (operand, "ip");
			break;
		case ETHERPUP_ARPTYPE:
			strcpy (operand, "arp");
			break;
		case ETHERPUP_REVARPTYPE:
			strcpy (operand, "rarp");
			break;
		default:
			sprintf (operand, "%x", insn->aux);
		}
		break;

	case AddOp_0:
	case SubOp_0:
	case MulOp_0:
	case DivOp_0:
	case AndOp_0:
	case OrOp_0:
		jump = 0;
		/* fall through */
	case GTOp_0:
	case GEOp_0:
	case LTOp_0:
	case LEOp_0:
	case EQOp_0:
	case NEOp_0:
		strcpy (operand, "r1, r0");
		break;

	case AddOp_1:
	case SubOp_1:
	case MulOp_1:
	case DivOp_1:
	case AndOp_1:
	case OrOp_1:
		jump = 0;
		/* fall through */
	case GTOp_1:
	case GEOp_1:
	case LTOp_1:
	case LEOp_1:
	case EQOp_1:
	case NEOp_1:
		strcpy (operand, "r2, r0");
		break;

	case AddOp_2:
	case SubOp_2:
	case MulOp_2:
	case DivOp_2:
	case AndOp_2:
	case OrOp_2:
		jump = 0;
		/* fall through */
	case GTOp_2:
	case GEOp_2:
	case LTOp_2:
	case LEOp_2:
	case EQOp_2:
	case NEOp_2:
		strcpy (operand, "r0, r1");
		break;

	case AddOp_3:
	case SubOp_3:
	case MulOp_3:
	case DivOp_3:
	case AndOp_3:
	case OrOp_3:
		jump = 0;
		/* fall through */
	case GTOp_3:
	case GEOp_3:
	case LTOp_3:
	case LEOp_3:
	case EQOp_3:
	case NEOp_3:
		strcpy (operand, "r2, r1");
		break;

	case AddOp_4:
	case SubOp_4:
	case MulOp_4:
	case DivOp_4:
	case AndOp_4:
	case OrOp_4:
		jump = 0;
		/* fall through */
	case GTOp_4:
	case GEOp_4:
	case LTOp_4:
	case LEOp_4:
	case EQOp_4:
	case NEOp_4:
		sprintf (operand, "r0, r2");
		break;

	case AddOp_5:
	case SubOp_5:
	case MulOp_5:
	case DivOp_5:
	case AndOp_5:
	case OrOp_5:
		jump = 0;
		/* fall through */
	case GTOp_5:
	case GEOp_5:
	case LTOp_5:
	case LEOp_5:
	case EQOp_5:
	case NEOp_5:
		strcpy (operand, "r1, r2");
		break;

	case LoadImmOp_0:
		sprintf (operand, "#%d, r0", insn->data[0]);
		jump = 0;
		break;

	case LoadImmOp_1:
		sprintf (operand, "#%d, r1", insn->data[0]);
		jump = 0;
		break;

	case LoadImmOp_2:
		sprintf (operand, "#%d, r2", insn->data[0]);
		jump = 0;
		break;

	case LoadEtherOp_0:
	case LoadIpOp_0:
	case LoadArpOp_0:
	case LoadRarpOp_0:
	case LoadTcpOp_0:
	case LoadUdpOp_0:
		sprintf (operand, "(r0), r0  /%c", 
			 insn->aux == sizeof (int) ? 'w' :
			 (insn->aux == sizeof (short) ? 'h' : 'b'));
		jump = 0;
		break;

	case LoadEtherOp_1:
	case LoadIpOp_1:
	case LoadArpOp_1:
	case LoadRarpOp_1:
	case LoadTcpOp_1:
	case LoadUdpOp_1:
		sprintf (operand, "(r1), r1  /%c", 
			 insn->aux == sizeof (int) ? 'w' :
			 (insn->aux == sizeof (short) ? 'h' : 'b'));
		jump = 0;
		break;

	case LoadEtherOp_2:
	case LoadIpOp_2:
	case LoadArpOp_2:
	case LoadRarpOp_2:
	case LoadTcpOp_2:
	case LoadUdpOp_2:
		sprintf (operand, "(r2), r2  /%c", 
			 insn->aux == sizeof (int) ? 'w' :
			 (insn->aux == sizeof (short) ? 'h' : 'b'));
		jump = 0;
		break;

	case AcceptOp:
	case RejectOp:
	case UndefOp:
		operand[0] = '\0';
		jump = 0;
		break;
	}
	printf ("%-20s", operand);
	if (jump)
		printf ("\tjt %d\tjf %d", insn->jt + i, insn->jf + i);
	putchar ('\n');
}

void 
show_code (fcode, len)
	int *fcode;
	int len;
{
	register int i = 0;

	while (i < len) {
		show_op (&fcode[i], i);
		i += insn_size[((struct insn *)&fcode[i])->opcode];
	}
}

#ifdef DEBUG
/* for use inside the debugger */
void
px (p)
	struct insn *p;
{
	show_op (p, 0);
}
#endif
