/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Lawrence Berkeley Laboratory,
 * Berkeley, CA.  The name of the University may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static char rcsid[] =
    "@(#) $Header: udp_print.c,v 1.6 90/01/12 15:34:03 mccanne Exp $ (LBL)";
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netinet/udp.h>
#include <netinet/udp_var.h>

#include <arpa/nameser.h>
#include <errno.h>
#include <sys/time.h>
#include <rpc/types.h>
#include <rpc/auth.h>
#include <rpc/auth_unix.h>
#include <rpc/svc.h>
#include <rpc/xdr.h>
#include <rpc/rpc_msg.h>
#include <nfs/nfs.h>

#include "interface.h"
#include "netstrings.h"
#include "appletalk.h"

#define RIP_PORT 520	/*XXX*/

void
udp_print (up, length, ip)
	register struct udphdr *up;
	int length;
	register struct ip *ip;
{
	register u_char  *cp = (u_char *)(up + 1);

	if (length < sizeof (struct udphdr)) {
		(void)printf (" truncated-udp %d", length);
		return;
	}
	length -= sizeof(struct udphdr);
	if (! qflag) {
		register struct rpc_msg *rp  = (struct rpc_msg *)(up + 1);
		if (up->uh_dport == NFS_PORT && rp->rm_direction == CALL) {
			nfsreq_print (rp, length, ip);
			return;
		}
		else if (up->uh_sport == NFS_PORT && rp->rm_direction==REPLY) {
			nfsreply_print (rp, length, ip);
			return;
		}
		else if (cp[2] == 2 && (atalk_port(up->uh_sport) ||
			 atalk_port(up->uh_dport))) {
			ddp_print((struct atDDP *)(&cp[3]), length - 3);
			return;
		}
	}
	(void)printf (" %s.%s > %s.%s:",
		ipaddr_string (&ip->ip_src), udpport_string (up->uh_sport),
		ipaddr_string (&ip->ip_dst), udpport_string (up->uh_dport));

	if (!qflag) {
		if (up->uh_dport == NAMESERVER_PORT ||
		    up->uh_sport == NAMESERVER_PORT)
			ns_print ((HEADER *)(up + 1), length);
		else if (up->uh_dport == RIP_PORT)
			rip_print((u_char *)(up + 1), length);
	} else
		(void)printf (" udp %d", up->uh_ulen - sizeof (*up));
}
