/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Lawrence Berkeley Laboratory,
 * Berkeley, CA.  The name of the University may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * @(#) $Header: sample.h,v 1.1 89/06/24 23:34:02 mccanne Exp $ (LBL)
 */

struct sample {
        struct  ether_header ts_eheader;
        union {
                struct  udpiphdr tsu_udpipheader;
		struct  tcpiphdr tsu_tcpipheader;
                struct ether_arp tsu_arpheader;
        } tsu;
#define ts_ipovlyheader tsu.tsu_udpipheader.ui_i
#define ts_udpheader    tsu.tsu_udpipheader.ui_u
#define ts_tcpheader    tsu.tsu_tcpipheader.ti_t
#define ts_arpheader    tsu.tsu_arpheader
};

#define Ip(sp)		((struct ip *)((u_char *)sp +\
				       sizeof (struct ether_header)))
#define Arp(sp)		((struct ether_arp *)((u_char *)sp +\
					      sizeof (struct ether_header)))
#define UdpIp(sp)	(&(((struct udpiphdr *)Ip(sp))->ui_u))
#define TcpIp(sp)	(&(((struct tcpiphdr *)Ip(sp))->ti_t))
#define	TYPE(sp)	(((struct ether_header *)sp)->ether_type)
