/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Lawrence Berkeley Laboratory,
 * Berkeley, CA.  The name of the University may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
#ifndef lint
static char rcsid[] =
    "@(#) $Header: nfs_print.c,v 1.4 90/01/12 15:41:52 mccanne Exp $ (LBL)";
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>

#include <sys/time.h>
#include <errno.h>
#include <rpc/types.h>
#include <rpc/auth.h>
#include <rpc/auth_unix.h>
#include <rpc/svc.h>
#include <rpc/xdr.h>
#include <rpc/rpc_msg.h>
#include <nfs/nfs.h>

#include <ctype.h>

#include "interface.h"
#include "netstrings.h"

static void printfh (), printfn ();

void
nfsreply_print (rp, length, ip)
	register struct rpc_msg *rp;
	int length;
	register struct ip *ip;
{
	(void)printf (" %s.nfs > %s.%x: reply %s %d",
			ipaddr_string (&ip->ip_src),
			ipaddr_string (&ip->ip_dst),
			rp->rm_xid,
			rp->rm_reply.rp_stat == MSG_ACCEPTED? "ok":"ERR",
			length);
}

void
nfsreq_print (rp, length, ip)
	register struct rpc_msg *rp;
	int length;
	register struct ip *ip;
{
	register u_long *dp; 
	register u_long *ep = (u_long *)((u_char *)ip + snaplen 
				- sizeof(struct ether_header));

	(void)printf (" %s.%x > %s.nfs: %d",
			ipaddr_string (&ip->ip_src),
			rp->rm_xid,
			ipaddr_string (&ip->ip_dst),
			length);

	/* find the start of the req data (if we captured it) */
	dp = (u_long *)(&rp->rm_call.cb_cred);
	if (dp < ep) {
		dp += (dp[1] + (2*sizeof(u_long) + 3)) / sizeof(u_long);
		if (dp < ep) {
			dp += (dp[1] + (2*sizeof(u_long) + 3)) / sizeof(u_long);
			if (dp >= ep)
				dp = 0;
		} else
			dp = 0;
	} else
		dp = 0;

	switch (rp->rm_call.cb_proc) {
	case RFS_NULL:
		printf (" null");
		break;
	case RFS_GETATTR:
		printf (" getattr");
		if (dp)
			printfh (dp);
		break;
	case RFS_SETATTR:
		printf (" setattr");
		if (dp)
			printfh (dp);
		break;
	case RFS_ROOT:
		printf (" root");
		break;
	case RFS_LOOKUP:
		printf (" lookup");
		if (dp) {
			printfh (dp);
			printfn (&dp[8]);
		}
		break;
	case RFS_READLINK:
		printf (" readlink");
		if (dp)
			printfh (dp);
		break;
	case RFS_READ:
		printf (" read");
		if (dp) {
			printfh (dp);
			printf (" %d (%d) bytes @ %d", dp[9], dp[10], dp[8]);
		}
		break;
	case RFS_WRITECACHE:
		printf (" writecache");
		if (dp) {
			printfh (dp);
			printf (" %d (%d) bytes @ %d (%d)", 
				dp[11], dp[10], dp[9], dp[8]);
		}
		break;
	case RFS_WRITE:
		printf (" write");
		if (dp) {
			printfh (dp);
			printf (" %d (%d) bytes @ %d (%d)",
				dp[11], dp[10], dp[9], dp[8]);
		}
		break;
	case RFS_CREATE:
		printf (" create");
		if (dp) {
			printfh (dp);
			printfn (&dp[8]);
		}
		break;
	case RFS_REMOVE:
		printf (" remove");
		if (dp) {
			printfh (dp);
			printfn (&dp[8]);
		}
		break;
	case RFS_RENAME:
		printf (" rename");
		if (dp) {
			printfh (dp);
			printfn (&dp[8]);
		}
		break;
	case RFS_LINK:
		printf (" link");
		if (dp)
			printfh (dp);
		break;
	case RFS_SYMLINK:
		printf (" symlink");
		if (dp) {
			printfh (dp);
			printfn (&dp[8]);
		}
		break;
	case RFS_MKDIR:
		printf (" mkdir");
		if (dp) {
			printfh (dp);
			printfn (&dp[8]);
		}
		break;
	case RFS_RMDIR:
		printf (" rmdir");
		if (dp) {
			printfh (dp);
			printfn (&dp[8]);
		}
		break;
	case RFS_READDIR:
		printf (" readdir");
		if (dp) {
			printfh (dp);
			printf (" %d bytes @ %d", dp[9], dp[8]);
		}
		break;
	case RFS_STATFS:
		printf (" statfs");
		if (dp)
			printfh (dp);
		break;
	case RFS_NPROC:
		printf (" nproc");
		break;
	default:
		printf (" proc-%d", rp->rm_call.cb_proc);
		break;
	}
}

static void
printfh (dp)
	register u_long *dp;
{
	/*
	 * take a wild guess at the structure of file handles.
	 * On sun 3s, there are 2 longs of fsid, a short
	 * len == 8, a long of inode & a long of generation number.
	 * On sun 4s, the len == 10 & there are 2 bytes of
	 * padding immediately following it.
	 */
	if (dp[2] == 0xa0000) {
		if (dp[1])
			(void) printf (" fh %d.%d.%d", dp[0], dp[1], dp[3]);
		else
			(void) printf (" fh %d.%d", dp[0], dp[3]);
	} else if ((dp[2] >> 16) == 8)
		if (dp[1])
			(void) printf (" fh %d.%d.%d", dp[0], dp[1],
					*(u_long *)((u_char *)dp + 10));
		else
			(void) printf (" fh %d.%d", dp[0],
					*(u_long *)((u_char *)dp + 10));
	else
		(void) printf (" fh %x.%x.%x.%x", dp[0], dp[1], dp[2], dp[3]);
}

static void
printfn (dp)
	u_long *dp;
{
	register u_int i = *dp++;
	register u_char *cp = (u_char *)dp;
	register u_char c;

	if (i < 64) {	/* sanity */
		putchar (' ');
		putchar ('`');
		do {
			putchar (isprint(c = *cp++)? c : '?');
		} while (--i);
		putchar ('\'');
	}
}
