/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Lawrence Berkeley Laboratory,
 * Berkeley, CA.  The name of the University may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

/*
 * @(#) $Header: filter.h,v 1.2 90/01/12 18:12:20 mccanne Exp $ (LBL)
 */

/*
 * The definitions below represent the instruction set of an abstract machine
 * model which is the target language of the command line parser.
 * Expressions are compiled into a flow-of-control evalution scheme.
 *
 * The opcodes are numbered symetrically to facilitate generation.
 * Dst ops come after src ops.
 * The host/net ops are grouped into protocol groups, with
 * nets coming after hosts.
 *
 * The routine genOpCode() is sensitive to this encoding.
 */

#define ESrcOp		0x00
#define EDstOp		0x01

#define IpSrcOp		0x02
#define IpDstOp		0x03
#define IpSrcNetOp	0x04
#define IpDstNetOp	0x05

#define ArpSrcOp	0x06
#define ArpDstOp	0x07
#define ArpSrcNetOp	0x08
#define ArpDstNetOp	0x09

#define RarpSrcOp	0x0a
#define RarpDstOp	0x0b
#define RarpSrcNetOp	0x0c
#define RarpDstNetOp	0x0d

#define TcpSrcPortOp	0x0e
#define TcpDstPortOp	0x0f

#define UdpSrcPortOp	0x10
#define UdpDstPortOp	0x11
		
#define IpProtoOp	0x12
#define EtherProtoOp	0x13

#define LessOp		0x14
#define GreaterOp	0x15

#define AndByteOp	0x16
#define OrByteOp	0x17
#define EqByteOp	0x18
#define LTByteOp	0x19
#define GTByteOp	0x1a

#define GTOp		0x1b	/* @ */
#define 	GTOp_0	(GTOp+0)
#define 	GTOp_1	(GTOp+1)
#define 	GTOp_2	(GTOp+2)
#define 	GTOp_3	(GTOp+3)
#define 	GTOp_4	(GTOp+4)
#define 	GTOp_5	(GTOp+5)

#define GEOp		0x21	/* @ */
#define 	GEOp_0	(GEOp+0)
#define 	GEOp_1	(GEOp+1)
#define 	GEOp_2	(GEOp+2)
#define 	GEOp_3	(GEOp+3)
#define 	GEOp_4	(GEOp+4)
#define 	GEOp_5	(GEOp+5)

#define LTOp		0x27	/* @ */
#define 	LTOp_0	(LTOp+0)
#define 	LTOp_1	(LTOp+1)
#define 	LTOp_2	(LTOp+2)
#define 	LTOp_3	(LTOp+3)
#define 	LTOp_4	(LTOp+4)
#define 	LTOp_5	(LTOp+5)

#define LEOp		0x2d	/* @ */
#define 	LEOp_0	(LEOp+0)
#define 	LEOp_1	(LEOp+1)
#define 	LEOp_2	(LEOp+2)
#define 	LEOp_3	(LEOp+3)
#define 	LEOp_4	(LEOp+4)
#define 	LEOp_5	(LEOp+5)

#define EQOp		0x33	/* @ */
#define 	EQOp_0	(EQOp+0)
#define 	EQOp_1	(EQOp+1)
#define 	EQOp_2	(EQOp+2)
#define 	EQOp_3	(EQOp+3)
#define 	EQOp_4	(EQOp+4)
#define 	EQOp_5	(EQOp+5)

#define NEOp		0x39	/* @ */
#define 	NEOp_0	(NEOp+0)
#define 	NEOp_1	(NEOp+1)
#define 	NEOp_2	(NEOp+2)
#define 	NEOp_3	(NEOp+3)
#define 	NEOp_4	(NEOp+4)
#define 	NEOp_5	(NEOp+5)

#define AddOp		0x3f	/* @ */
#define 	AddOp_0	(AddOp+0)
#define 	AddOp_1	(AddOp+1)
#define 	AddOp_2	(AddOp+2)
#define 	AddOp_3	(AddOp+3)
#define 	AddOp_4	(AddOp+4)
#define 	AddOp_5	(AddOp+5)

#define SubOp		0x45	/* @ */
#define 	SubOp_0	(SubOp+0)
#define 	SubOp_1	(SubOp+1)
#define 	SubOp_2	(SubOp+2)
#define 	SubOp_3	(SubOp+3)
#define 	SubOp_4	(SubOp+4)
#define 	SubOp_5	(SubOp+5)

#define MulOp		0x4b	/* @ */
#define 	MulOp_0	(MulOp+0)
#define 	MulOp_1	(MulOp+1)
#define 	MulOp_2	(MulOp+2)
#define 	MulOp_3	(MulOp+3)
#define 	MulOp_4	(MulOp+4)
#define 	MulOp_5	(MulOp+5)

#define DivOp		0x51	/* @ */
#define 	DivOp_0	(DivOp+0)
#define 	DivOp_1	(DivOp+1)
#define 	DivOp_2	(DivOp+2)
#define 	DivOp_3	(DivOp+3)
#define 	DivOp_4	(DivOp+4)
#define 	DivOp_5	(DivOp+5)

#define AndOp		0x57	/* @ */
#define 	AndOp_0	(AndOp+0)
#define 	AndOp_1	(AndOp+1)
#define 	AndOp_2	(AndOp+2)
#define 	AndOp_3	(AndOp+3)
#define 	AndOp_4	(AndOp+4)
#define 	AndOp_5	(AndOp+5)

#define OrOp		0x5d	/* @ */
#define 	OrOp_0	(OrOp+0)
#define 	OrOp_1	(OrOp+1)
#define 	OrOp_2	(OrOp+2)
#define 	OrOp_3	(OrOp+3)
#define 	OrOp_4	(OrOp+4)
#define 	OrOp_5	(OrOp+5)

#define LoadImmOp	0x63	/* @ */
#define LoadImmOp_0	(LoadImmOp+0)
#define LoadImmOp_1	(LoadImmOp+1)
#define LoadImmOp_2	(LoadImmOp+2)

/* This opcodes sensitive to code generation.  Must appear in same order
   as 'Q_' protocols in tcpgram.y */

#define N_PROTOCOLS 6		/* @ */

#define LoadEtherOp	0x66	/* @ */
#define LoadIpOp	0x67	/* @ */
#define LoadArpOp	0x68	/* @ */
#define LoadRarpOp	0x69	/* @ */
#define LoadTcpOp	0x6a	/* @ */
#define LoadUdpOp	0x6b	/* @ */

#define LoadEtherOp_0	LoadEtherOp
#define LoadIpOp_0	LoadIpOp
#define LoadArpOp_0	LoadArpOp
#define LoadRarpOp_0	LoadRarpOp
#define LoadTcpOp_0	LoadTcpOp
#define LoadUdpOp_0	LoadUdpOp

#define LoadEtherOp_1	(LoadEtherOp+6)
#define LoadIpOp_1	(LoadIpOp+6)
#define LoadArpOp_1	(LoadArpOp+6)
#define LoadRarpOp_1	(LoadRarpOp+6)
#define LoadTcpOp_1	(LoadTcpOp+6)
#define LoadUdpOp_1	(LoadUdpOp+6)

#define LoadEtherOp_2	(LoadEtherOp+12)
#define LoadIpOp_2	(LoadIpOp+12)
#define LoadArpOp_2	(LoadArpOp+12)
#define LoadRarpOp_2	(LoadRarpOp+12)
#define LoadTcpOp_2	(LoadTcpOp+12)
#define LoadUdpOp_2	(LoadUdpOp+12)

#define AcceptOp	0x78
#define RejectOp	0x79

#define UndefOp		0x7a

/*
 * The instruction data structure.  Each instruction consists of an opcode,
 * two jump destinations, and data fields.
 * Note that the parser uses the 'jt' field as the jump type (i.e. JF or JT)
 * and the 'jf' field as the absolute jump destination.  These absolute
 * targets are converted to relative offsets by pass2.
 *
 * To accommodate variable size instructions, the code is maintained in
 * an integer array and instruction fields are accessed by superimposing
 * the data structure below at the appropriate offset.
 */
struct insn {
	unsigned short opcode;
	unsigned short aux;
	short jt;
	short jf;
	int data[1];
};

extern int execute ();
extern const int insn_size[];

/*
 * The jump instruction opcodes come before and only before the
 * LoadImmOp code.
 */
#define isJump(index)		(OpCode(index) < AddOp)
#define isLeaf(index)		(OpCode(index) == AcceptOp || \
				 OpCode(index) == RejectOp)
#define HasSideEffects(index)	(OpCode(index) >= AddOp && \
				 OpCode(index) < AcceptOp)
#define UsesSideEffects(index)	(OpCode(index) >= GTOp && \
				 OpCode(index) < AddOp)
