/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Lawrence Berkeley Laboratory,
 * Berkeley, CA.  The name of the University may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
#ifndef lint
static char rcsid[] =
    "@(#) $Header: arp_print.c,v 1.4 90/01/12 15:44:36 mccanne Exp $ (LBL)";
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>

#ifdef SUNOS4
#include "sunos4.map.h"
#endif

#include "interface.h"
#include "netstrings.h"

void
arp_print (ap, length)
	register struct ether_arp *ap;
	int length;
{

	if (length < sizeof(struct ether_arp)) {
		(void)printf ("truncated-arp");
		default_print ((u_short *)ap, length);
		return;
	}
	if (ap->arp_hrd != ARPHRD_ETHER
	    || ap->arp_pro != ETHERPUP_IPTYPE
	    || ap->arp_hln != sizeof(ap->arp_xsha)
	    || ap->arp_pln != sizeof(ap->arp_xspa)) {
		(void)printf ("arp-req #%d for proto #%d (%d) hardware %d (%d)",
				ap->arp_op, ap->arp_pro, ap->arp_pln,
				ap->arp_hrd, ap->arp_hln);
		return;
	}
	switch (ap->arp_op) {

	case ARPOP_REQUEST:
		(void)printf (" arp who-has %s tell %s",
			ipaddr_string (ap->arp_xtpa),
			ipaddr_string (ap->arp_xspa));
		break;

	case ARPOP_REPLY:
		(void)printf (" arp reply %s is-at %s",
			ipaddr_string (ap->arp_xspa),
			etheraddr_string (ap->arp_xsha));
		break;

	case REVARP_REQUEST:
		(void)printf (" rarp who-is %s tell %s",
			etheraddr_string (ap->arp_xtha),
			etheraddr_string (ap->arp_xsha));
		break;

	case REVARP_REPLY:
		(void)printf (" rarp reply %s at %s",
			etheraddr_string (ap->arp_xtha),
			ipaddr_string (ap->arp_xtpa));
		break;

	default:
		(void)printf (" arp-%d", ap->arp_op);
		default_print ((u_short *)ap, length);
		break;
	}
}
