/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Lawrence Berkeley Laboratory,
 * Berkeley, CA.  The name of the University may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *  Internet, ethernet, port, and protocol string to address
 *  and address to string conversion routines
 */

#ifndef lint
static char rcsid[] =
    "@(#) $Header: netstrings.c,v 1.7 90/01/12 14:48:41 mccanne Exp $ (LBL)";
#endif

#include <stdio.h>
#include <strings.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netdb.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <arpa/inet.h>
#include <signal.h>

#include "interface.h"
#include "netstrings.h"

/*
 * hash tables for whatever-to-name translations
 */

#define HASHNAMESIZE 4096

struct hnamemem {
	u_int addr;
	char *name;
	struct hnamemem *nxt;
};

struct hnamemem hnametable[HASHNAMESIZE];
struct hnamemem tporttable[HASHNAMESIZE];
struct hnamemem uporttable[HASHNAMESIZE];
struct hnamemem eprototable[HASHNAMESIZE];

struct enamemem {
	u_short e_addr0;
	u_short e_addr1;
	u_short e_addr2;
	char *e_name;
	struct enamemem *e_nxt;
};

struct enamemem enametable[HASHNAMESIZE];


/*
 * "getname" is written in this atrocious way to make sure we don't
 * wait forever while trying to get hostnames from yp.
 */
#include <setjmp.h>

jmp_buf getname_env;

static void
nohostname ()
{
	longjmp (getname_env, 1);
}

char *
getname(addr)
	int addr;
{
	register struct hnamemem *p;
	register struct hostent *hp;
	register u_int raddr = addr;
	register char *cp;

	for (p = &hnametable[raddr & (HASHNAMESIZE-1)]; p->nxt; p = p->nxt) {
		if (p->addr == raddr)
			return (p->name);
	}
	p->addr = raddr;
	p->nxt = (struct hnamemem *)calloc (1, sizeof (*p));

	if (!nflag && (raddr & netmask) == localnet) {
		if (! setjmp(getname_env)) {
			signal (SIGALRM, nohostname);
			alarm (20);
	            	hp = gethostbyaddr((char *)&addr, sizeof(int), AF_INET);
			alarm (0);
			if (hp) {
				p->name = malloc((unsigned)(strlen(hp->h_name)
						+ 1));
				(void)strcpy(p->name, hp->h_name);
				return (p->name);
			}
		}
	}
	{
		/*
		 * This is a roundabout way of passing an int to INET_NTOA, 
		 * but a good optimizer fixes it.
		 */
		struct in_addr s;

		s.s_addr = raddr;
		cp = inet_ntoa (s);
	}
	p->name = malloc((unsigned)(strlen(cp) + 1));
	(void)strcpy(p->name, cp);
	return (p->name);
}

static char *hex = "0123456789abcdef";

char *
etheraddr_string (ep)
	register u_char *ep;
{
	register u_int i, j;
	register char *cp;
	register struct enamemem *tp;
	char buf[128];

	i = *(u_short *)(ep + 2);
	j = *(u_short *)(ep + 4);

	tp = &enametable[(i ^ j) & (HASHNAMESIZE-1)];

	while (tp->e_nxt)

		if (tp->e_addr0 == i &&
		    tp->e_addr1 == j &&
		    tp->e_addr2 == *(u_short *)ep)

			return tp->e_name;
		else 
			tp = tp->e_nxt;

	tp->e_addr0 = i;
	tp->e_addr1 = j;
	tp->e_addr2 = *(u_short *)ep;
	tp->e_nxt = (struct enamemem *)calloc (1, sizeof (*tp));

	if (!nflag && !ether_ntohost (buf, (struct ether_addr *)ep)) {
		tp->e_name = malloc ((unsigned)strlen(buf)+1);
		strcpy (tp->e_name, buf);
	} else {
		tp->e_name = cp = malloc (sizeof("00:00:00:00:00:00"));

		if (j = *ep >> 4)
			*cp++ = hex[j];
		*cp++ = hex[*ep++ & 0xf];
		for (i = 5; (int)--i >= 0;) {
			*cp++ = ':';
			if (j = *ep >> 4)
				*cp++ = hex[j];
			*cp++ = hex[*ep++ & 0xf];
		}
		*cp++ = '\0';
	}
	return (tp->e_name);
}


char *
etherproto_string (port)
	unsigned short port;
{
	register char *cp;
	register struct hnamemem *tp;
	register int i = port;

	for (tp = &eprototable[i & (HASHNAMESIZE-1)]; tp->nxt; tp = tp->nxt)
		if (tp->addr == i)
			return (tp->name);

	tp->name = cp = malloc (sizeof("0000"));
	tp->addr = i;
	tp->nxt = (struct hnamemem *)calloc (1, sizeof (*tp));

	*cp++ = hex[port >> 12 & 0xf];
	*cp++ = hex[port >> 8 & 0xf];
	*cp++ = hex[port >> 4 & 0xf];
	*cp++ = hex[port & 0xf];
	*cp++ = '\0';
	return (tp->name);
}

char *
tcpport_string (port)
	unsigned short port;
{
	register char *cp;
	register struct hnamemem *tp;
	register int i = port;

	for (tp = &tporttable[i & (HASHNAMESIZE-1)]; tp->nxt; tp = tp->nxt)
		if (tp->addr == i)
			return (tp->name);

	tp->name = cp = malloc (sizeof("00000"));
	tp->addr = i;
	tp->nxt = (struct hnamemem *)calloc (1, sizeof (*tp));

	(void)sprintf (cp, "%d", i);
	return (cp);
}


char *
udpport_string (port)
	register unsigned short port;
{
	register char *cp;
	register struct hnamemem *tp;
	register int i = port;

	for (tp = &uporttable[i & (HASHNAMESIZE-1)]; tp->nxt; tp = tp->nxt)
		if (tp->addr == i)
			return (tp->name);

	tp->name = cp = malloc (sizeof("00000"));
	tp->addr = i;
	tp->nxt = (struct hnamemem *)calloc (1, sizeof (*tp));

	(void)sprintf (cp, "%d", i);
	return (cp);
}

void
initservarray()
{
	struct servent *sv;
	register struct hnamemem *table;
	register int index;

	while(sv = getservent()) {
		index = sv->s_port & (HASHNAMESIZE-1);
		if (strcmp(sv->s_proto, "tcp") == 0)
			table = &tporttable[index];
		else if (strcmp(sv->s_proto, "udp") == 0)
			table = &uporttable[index];
		else
			continue;

		while (table->name)
			table = table->nxt;
		table->name = malloc((unsigned)strlen(sv->s_name) + 1);
		(void)strcpy(table->name, sv->s_name);
		table->addr = sv->s_port;
		table->nxt = (struct hnamemem *)calloc (1, sizeof(*table));
	}
	endservent();
}
