/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Lawrence Berkeley Laboratory,
 * Berkeley, CA.  The name of the University may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * @(#) $Header: netstrings.h,v 1.1 90/01/12 14:47:49 mccanne Exp $ (LBL)
 */

/* Network string handling module */

extern unsigned long s_nametoaddr();
extern unsigned long s_nametonetaddr();
extern struct ether_addr *s_nametoeaddr();
extern struct ether_addr *s_numstrtoeaddr();
extern int s_nametoport();
extern int s_nametoproto();

extern char *eaddrtoname();
extern char *porttoname();
extern char *prototoname();

extern char *etheraddr_string ();
extern char *etherproto_string ();
extern char *tcpport_string ();
extern char *udpport_string ();
extern char *getname ();

extern void initservarray ();

#ifndef ALIGN
#define ipaddr_string(p) getname (*(int *)(p))
#define ipaddr_string_bytewise(p) getname (*(int *)(p))
#else
#define ipaddr_string(p) getname (((*(u_short *)(p))<<16)|*(((u_short *)p)+1))
#define ipaddr_string_bytewise(p)\
	getname (((*(u_char *)(p))<<24)|*(((u_char *)(p))+1)<<16|\
		 *(((u_char *)p)+2)<<8|*(((u_char *)p)+3))
#endif
