/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Lawrence Berkeley Laboratory,
 * Berkeley, CA.  The name of the University may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * @(#) $Header: interface.h,v 1.9 90/01/12 18:12:23 mccanne Exp $ (LBL)
 */

#ifdef sparc
#define ALIGN
#endif

#ifndef TRUE
#define TRUE  1
#define FALSE 0
#endif

#ifndef __GNUC__
#define const
#define inline
#endif

extern char *malloc ();
extern char *calloc ();

extern int nflag;		/* leave addresses as numbers */
extern int qflag;		/* quick (shorter) output */
extern int tflag;		/* print packet arrival time */
extern int eflag;		/* print ethernet header */
extern int xflag;		/* print packet in hex */
extern int vflag;
extern int dflag;		/* print filter code */

extern unsigned long localnet, netmask;
extern int snaplen;

extern void usage ();
extern void punt ();
extern void show_code ();
extern void optimize ();

/* The printer routines. */

extern void ether_print ();
extern void arp_print ();
extern void ip_print ();
extern void tcp_print ();
extern void udp_print ();
extern void icmp_print ();
extern void default_print ();

extern void nfsreq_print ();
extern void nfsreply_print ();
extern void ns_print ();
extern void ddp_print ();
extern void rip_print ();
extern void sl_if_print ();
#ifdef CSLIP
void sl_if_print();
#endif

#define min(a,b) ((a)>(b)?(b):(a))
#define max(a,b) ((b)>(a)?(b):(a))

