/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Lawrence Berkeley Laboratory,
 * Berkeley, CA.  The name of the University may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
#ifndef lint
static char rcsid[] =
    "@(#) $Header: ether_print.c,v 1.4 90/01/12 14:50:57 mccanne Exp $ (LBL)";
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netinet/udp.h>
#include <netinet/udp_var.h>
#include <netinet/tcp.h>
#include <netinet/tcpip.h>

#include "interface.h"
#include "netstrings.h"

void
ether_print (sp, length)
	register struct ether_header *sp;
	int length;
{
	if (qflag)
		(void)printf (" %s %s %d:",
			      etheraddr_string((u_char *)&sp->ether_shost),
			      etheraddr_string((u_char *)&sp->ether_dhost),
			      length);
	else
		(void)printf (" %s %s %s %4d:",
			      etheraddr_string((u_char *)&sp->ether_shost),
			      etheraddr_string((u_char *)&sp->ether_dhost),
			      etherproto_string (sp->ether_type),
			      length);
}
