/*
	Written by Ross Cartlidge (rossc@extro.ucc.su.oz)
	University Computer Service
	March 1989

*/
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <signal.h>
#include <sys/fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>

#if !defined(FD_SET)
#define	fd_set	int
#define	FD_SET(n,p)	(*(p) |= 1 << (n))
#define	FD_CLR(n,p)	(*(p) &= ~(1 << (n)))
#define	FD_ISSET(n,p)	(*(p) & 1 << (n))
#define	FD_ZERO(p)	(*(p) = 0)
#endif


#define	BUFSIZE	1024
char			buf[BUFSIZE];

main(argc, argv)
int	argc;
char	*argv[];
{
	struct sockaddr_in	sin;
	struct sockaddr_in	from;
	int			fromlen;
	int			s;
	int			c;
	int			errflg		= 0;
	int			r;
	char			perror_fmt[128];
	char			usage[128];
	int			nfds;
	fd_set			rfds;
	fd_set			efds;
	int			sockopt;
	int			con_type	= SOCK_STREAM;
	extern char		*optarg;
	extern int		optind;

	sprintf(perror_fmt, "PERROR_FMT=%s: %%t %%s%%m - (%%e)", argv[0]);
	sprintf(usage, "USAGE: %s <TCP Port>\n", argv[0]);
#if defined(SYSTYPE_SYSV)
	putenv(perror_fmt);
#endif
	while ((c = getopt(argc, argv, "u")) != -1)
		switch (c)
		{
		case 'u':
			con_type =  SOCK_DGRAM;
			break;
		case '?':
			errflg++;
			break;
		}
	if (errflg || optind  >= argc)
	{
		fputs(usage, stderr);
		exit(2);
	}
	if ((s = socket(AF_INET, con_type, 0)) < 0)
	{
		perror("socket");
		exit(1);
	}
	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = INADDR_ANY;
	if ((sin.sin_port = htons((short)strtol(argv[optind], (char **)0, 0))) <= 0)
	{
		fputs(usage, stderr);
		exit(2);
	}
	if (bind(s, (struct sockaddr *)&sin, sizeof sin) < 0)
	{
		perror("bind");
		exit(1);
	}
	if (con_type == SOCK_STREAM)
	{
		listen(s, 5);
		if ((s = accept(s, (struct sockaddr *)0, (int *)0)) < 0)
		{
			perror("accept");
			exit(1);
		}
		if
		(
			setsockopt
			(
				s,
				SOL_SOCKET,
				SO_KEEPALIVE,
				(sockopt = 1, (char *)&sockopt),
				sizeof sockopt
			)
			<
			0
		)
		{
			perror("setsockopt");
			exit(1);
		}
	}
	else
	{
		fromlen = sizeof from;
		if ((r = recvfrom(s, buf, sizeof buf, 0, &from , &fromlen)) == -1)
		{
			perror("recvfom");
			exit(1);
		}
		if (connect(s, &from, sizeof from) == -1)
		{
			perror("connect");
			exit(1);
		}
		if (write(1, buf, r) != r)
		{
			perror("write");
			exit(0);
		}
	}
	for (;;)
	{
		FD_ZERO(&rfds);
		FD_ZERO(&efds);
		FD_SET(0, &rfds);
		FD_SET(s, &rfds);
		FD_SET(0, &efds);
		FD_SET(s, &efds);
		select(s + 1, &rfds, (fd_set *)0, &efds, (struct timeval *)0);
		if (FD_ISSET(0, &rfds) || FD_ISSET(0, &efds))
		{
			if ((r = read(0, buf, BUFSIZE)) <= 0)
			{
				perror("read");
				exit(0);
			}
			if (write(s, buf, r) != r)
			{
				perror("write");
				exit(0);
			}
		}
		if (FD_ISSET(s, &rfds) || FD_ISSET(s, &efds))
		{
			if ((r = read(s, buf, BUFSIZE)) <= 0)
			{
				perror("read");
				exit(0);
			}
			if (write(1, buf, r) != r)
			{
				perror("write");
				exit(0);
			}
		}
	}
}
