/*
	Written by Ross Cartlidge (rossc@extro.ucc.su.oz)
	University Computer Service
	March 1989

	tcpcon - Program to connect a tty to a tcp socket
	Developed on a MIPS M/2000 running SysVr3
	Ported to BSD/SUN-OS
*/
#include	<fcntl.h>
#include	<sys/ioctl.h>
#include	<sys/signal.h>
#include	<sys/types.h>
#include	<syslog.h>
#include	<errno.h>
#include	<stdio.h>
#include	<string.h>

#include <sys/time.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <setjmp.h>

#define max(a,b) 	(a<b ? b : a)
#define min(a,b) 	(a>b ? b : a)

#if defined(SYSTYPE_BSD43)
#define sigset		signal
#define sighold(s)	sigblock(sigmask(s))
#define sigrelse(s)	sigsetmask(sigsetmask(-1) & ~sigmask(s))
extern int		errno;
#endif

#if !defined(FD_SET)
#define	fd_set	int
#define	FD_SET(n,p)	(*(p) |= 1 << (n))
#define	FD_CLR(n,p)	(*(p) &= ~(1 << (n)))
#define	FD_ISSET(n,p)	(*(p) & 1 << (n))
#define	FD_ZERO(p)	(*(p) = 0)
#endif

#define	BUFSIZE	1024

struct buf
{
	char	buf[BUFSIZE];
	int	cnt;
};

jmp_buf	env;
int	keepalive	= 0;
int	pid;

main(argc, argv)
int	argc;
char	*argv[];
{
	struct hostent		*host;
	struct servent		*serv;
	struct sockaddr_in	sin;
	int			s;
	int			i;
	int			r;
	char			perror_fmt[128];
	char			usage[128];
	int			p;
	fd_set			rfds;
	fd_set			efds;
	fd_set			wfds;
	int			mintime		= 2;
	int			minreads	= 2;
	char			*dev		= (char *)0;
	char			*kdev		= (char *)0;
	int			errflg		= 0;
	void			terminate();
	int			c;
	int			status;
	struct buf		*bufs;
	int			timeout();
	int			con_type	= SOCK_STREAM;
	extern char		*optarg;
	extern int		optind;

	sprintf(perror_fmt, "PERROR_FMT=%s: %%t %%s%%m - (%%e)", argv[0]);
	sprintf
	(
		usage,
		"USAGE: %s [-a] [-t mintime ] [-r minreads] [-l pty] [-k tty] <IP Address> <TCP Port>\n", argv[0]
	);
#if defined(SYSTYPE_SYSV)
	putenv(perror_fmt);
#endif
	while ((c = getopt(argc, argv, "at:l:r:k:u")) != -1)
		switch (c)
		{
		case 'u':
			con_type =  SOCK_DGRAM;
			break;
		case 'a':
			keepalive = 1;
			break;
		case 'k':
			kdev = optarg;
			break;
		case 't':
			mintime = atoi(optarg);
			break;
		case 'r':
			minreads = atoi(optarg);
			break;
		case 'l':
			dev = optarg;
			break;
		case '?':
			errflg++;
		}
	if (errflg || optind + 1 >= argc)
	{
		fputs(usage, stderr);
		exit(2);
	}
	if ((sin.sin_addr.s_addr = inet_addr(argv[optind])) != -1)
		sin.sin_family = AF_INET;
	else
	{
		if (host = gethostbyname(argv[optind]))
		{
			sin.sin_family = host->h_addrtype;
			memcpy(&sin.sin_addr.s_addr, host->h_addr, host->h_length);
		}
		else
		{
			fprintf
			(
				stderr,
				"%s: %s: unknown host\n",
				argv[0],
				argv[optind]
			);
			exit(2);
		}
	}
	if (serv = getservbyname(argv[optind + 1], "tcp"))
		sin.sin_port = serv->s_port;
	else
		if
		(
			(
				sin.sin_port
				=
				htons
				(
					(short)strtol(argv[optind + 1],
					(char **)0, 0)
				)
			)
			<=
			0
		)
		{
			fprintf
			(
				stderr,
				"%s: %s: unknown service\n",
				argv[0],
				argv[optind + 1]
			);
			exit(2);
		}
	if ((s = connectsocket(&sin, con_type)) < 0)
		exit(1);
	if ((bufs = (struct buf *)calloc(max(minreads, 1) ,sizeof (struct buf))) < 0)
	{
		perror("calloc bufs");
		exit(1);
	}
	sigset(SIGALRM, timeout);
	sighold(SIGALRM);
	alarm(mintime);
	if (setjmp(env) == 0)
		for (i = 0; i < minreads; i++)
		{
			sigrelse(SIGALRM);
			r = read(s, bufs[i].buf, BUFSIZE);
			sighold(SIGALRM);
			if (r <= 0)
				exit(1);
			else
				bufs[i].cnt = r;
		}
	alarm(0);
	sigset(SIGALRM, SIG_IGN);
	sigrelse(SIGALRM);
	if (dev)
	{
		close(0);
		close(1);
		sighold(SIGTERM);
		if (pid = fork())
		{
			sigset(SIGTERM, terminate);
			sigrelse(SIGTERM);
			if (kdev != (char *)0 && open(kdev, O_RDWR) == -1)
				kill(pid, SIGTERM);
#if defined(SYSTYPE_BSD43)
			ioctl(0, TIOCNOTTY, 0);
			setpgrp(0, getpid());
#endif
#if defined(SYSTYPE_SYSV)
			setpgrp();
#endif
			while (wait(&status) != -1 || errno == EINTR)
				;
			if ((status & 0xff) == 0 && (status >> 8 & 0xff))
				exit(status >> 8 & 0xff);
			else
				exit(0);
		}
#if defined(SYSTYPE_BSD43)
		ioctl(0, TIOCNOTTY, 0);
		setpgrp(0, getpid());
#endif
#if defined(SYSTYPE_SYSV)
		setpgrp();
#endif
		sigrelse(SIGTERM);
		if (open(dev, O_RDWR) == -1)
		{
			perror(dev);
			exit(1);
		}
		dup(0);
	}
	for (i = 0; i < minreads && bufs[i].cnt > 0; i++)
		if (write(1, bufs[i].buf, bufs[i].cnt) != bufs[i].cnt)
			exit(0);
	for (;;)
	{
		char	*buf	= bufs[0].buf;

		FD_ZERO(&rfds);
		FD_ZERO(&efds);
		FD_SET(0, &rfds);
		FD_SET(s, &rfds);
		FD_SET(0, &efds);
		FD_SET(s, &efds);
		select(s + 1, &rfds, (fd_set *)0, &efds, (struct timeval *)0);
		if (FD_ISSET(s, &rfds) || FD_ISSET(s, &efds))
		{
			if ((r = read(s, buf, BUFSIZE)) <= 0)
			{
				perror("read");
				exit(0);
			}
			if (write(1, buf, r) != r)
			{
				perror("write");
				exit(0);
			}
		}
		if ((FD_ISSET(0, &rfds) || FD_ISSET(0, &efds)))
		{
			if ((r = read(0, buf, BUFSIZE)) <= 0)
			{
				perror("read");
				exit(0);
			}
			if (write(s, buf, r) != r)
			{
				perror("write");
				exit(0);
			}
		}
	}
}

connectsocket(sinp, t)
struct sockaddr_in	*sinp;
int			t;
{
	int	s;
	int	l;
	int	sockopt;

	if ((s = socket(AF_INET, t, 0)) <  0)
	{
		perror("socket");
		return -1;
	}
	l = sizeof *sinp;
	if (connect(s, sinp, l) < 0)
	{
		perror("connect");
		return -1;
	}
	if
	(
		t == SOCK_STREAM
		&&
		keepalive == 1
		&&
		setsockopt
		(
			s,
			SOL_SOCKET,
			SO_KEEPALIVE,
			(sockopt = 1, (char *)&sockopt),
			sizeof sockopt
		)
		<
		0
	)
	{
		perror("setsockopt");
		return -1;
	}
	return s;
}

timeout(s)
int	s;
{
	longjmp(env, 1);
}

void
terminate(s)
int	s;
{
	kill(pid, s);
}
