
/* this file contains the I/O handling and the exchange of 
   edit characters. The connection itself is established in
   ctl.c (standard talk procedure)
 */

#include "talk.h"
#include <stdio.h>
#include <errno.h>
#include <sys/time.h>

#define A_LONG_TIME 10000000
#define STDIN_MASK (1<<fileno(stdin))	/* the bit mask for standard
					   input */
extern int	errno;
extern int	sys_nerr;
extern char	*sys_errlist[];

/*
 * The routine to do the actual talking - standard talk procedure
 */

talk(INPORT,OUTPORT)
int	INPORT, OUTPORT ;
{
    register int read_template, sockt_mask, inportmask;
    BMSG	buf;
    char string[10],ch;
    int read_set, nb,flag,nbuf=sizeof buf;
    struct timeval wait;

    current_line = 0;

    sockt_mask = (1<<sockt);
    inportmask = (1<<INPORT);

	/*
	 * wait on both the other process (sockt_mask) and 
	 * standard input ( STDIN_MASK )
	 */

    read_template = sockt_mask | inportmask;

    forever {

	read_set = read_template;

	wait.tv_sec = 100000;
	wait.tv_usec = 0;

	select(32, &read_set, 0, 0, &wait);

	if ( read_set & sockt_mask ) { 

		/* There is data on sockt */
	    nb=read(sockt,&buf,nbuf);
	    if(nb==nbuf)write(OUTPORT, &buf, nbuf);
	}
	
	if ( read_set & inportmask ) {

		/* we can't make the tty non_blocking, because
		   curses's output routines would screw up */
	    nb=read(INPORT,&buf,nbuf);
	    if(nb==nbuf)write(sockt, &buf, nbuf);
	}
    }
}





/*
 * input / output procedure, screen and editting controlling procedure
 */
talk1(INPORT,OUTPORT)
int 	INPORT, OUTPORT ;
{	char	ch,ins[40];
	char	status_msg[80];
	int	rtn, i,j,iwn,wn, readmask,read_template;
	int	sockt_mask,read_set;
	BMSG	buf;
	int	ki,nb,nbuf=sizeof buf;
	int	row, col, s_row, s_col, max_row, max_col ;
	int	irow, icol, is_row, is_col, imax_row, imax_col ;
	struct	timeval wait;

	iwn=3;ki=0;

	sockt_mask=(1<<INPORT);
	read_template=sockt_mask | STDIN_MASK;

	forever {
		read_set=read_template;
		wait.tv_sec=100000;
		wait.tv_usec=0;
		select(32,&read_set,0,0,&wait);
		/* 
		 * received message from master - place in appropriate window
		 */
		if(read_set&sockt_mask){
			nb=read(INPORT,&buf,nbuf);
		    if(nb==nbuf){
		        status("");
			wn=WN;
			s_row = userwindow[wn].start_row;
			s_col = userwindow[wn].start_col;
			row = userwindow[wn].cur_row;
			col = userwindow[wn].cur_col;
			max_row=userwindow[wn].nlines;
			max_col=userwindow[wn].ncols;
                        if(STR[0]=='\\'){
                             	write(OUTPORT,&buf,nbuf);
                             	endwin();exit();}
		 	if(STR[0]=='Z') wclear(userwindow[wn].win); 
                        if(STR[0]!='Z') {
				wmove(userwindow[wn].win,row,col);
				wprintw(userwindow[wn].win,"%s",STR);
				if (row<max_row-1) {
					row = row + 1 ;
				}
				else if (row == max_row-1) {
					row = s_row ;
				}
				wclrtoeol(userwindow[wn].win);
			}
			wrefresh(userwindow[wn].win);
			userwindow[wn].cur_row = row;
			userwindow[wn].cur_col = s_col;
		    }
		}
		/* 
		 * received input from keyboard
		 * put to [iwn] window (always bottom left)
		 * and send to master as soon as EOL or border detected
		 */
		if(read_set&STDIN_MASK){
			read(0,&ch,1);

			irow = userwindow[iwn].cur_row;
			icol = userwindow[iwn].cur_col;

			is_row = userwindow[iwn].start_row;
			is_col = userwindow[iwn].start_col;

			imax_row = userwindow[iwn].nlines;
			imax_col = userwindow[iwn].ncols;


			if (ch == 12) {	    			/* ^L */
				init_disp();
			}

			if (((ch==127) || (ch==8)) && (ki>0) && (icol>0)) {
				icol--;
				wmove(userwindow[iwn].win,irow,icol);
				wprintw(userwindow[iwn].win," ");
				wrefresh(userwindow[iwn].win);
				userwindow[iwn].cur_col=icol;
				ki--;
			}

		    	if ( (ch != 12) && (ch !=127) && (ch != 8) &&
			     (ch != '\n') ){ 		  /* anything else */
	               		ins[ki++]=ch;
				wmove(userwindow[iwn].win,irow,icol);
				wprintw(userwindow[iwn].win,"%c",ch);
				wrefresh(userwindow[iwn].win); 
				icol++;
				userwindow[iwn].cur_col=icol;
			}
					
			if((ki>=imax_col-1)&&(ch!='\n')){
				ch='\n';
				ins[ki++]=ch;
			}

			/* when got cr, send string to others */
			if(ch=='\n'){

				ins[ki++]=ch;

				waddch(userwindow[iwn].win,ch);

				++irow;
				if (irow == imax_row) {
					irow = is_row ;
				}

				wmove(userwindow[iwn].win,irow,is_col);

				userwindow[iwn].cur_row=irow;
				userwindow[iwn].cur_col=is_col; 

				wclrtoeol(userwindow[iwn].win);
				wrefresh(userwindow[iwn].win);

				ins[ki++]='\0';
				ki=0;
				strcpy(STR,ins);
				write(OUTPORT,&buf,nbuf);
			}
			sprintf(status_msg,"row: %d col: %d",irow,icol);
			status(status_msg) ;
		}
	}
}




    /* p_error prints the system error message on the standard location
       on the screen and then exits. (i.e. a curses version of perror)
     */

p_error(string) 
char *string;
{
    char *sys;

    sys = "Unknown error";
    if(errno < sys_nerr) {
	sys = sys_errlist[errno];
    }


    printf("[%s : %s (%d)]\n", string, sys, errno);
    quit();
}





/* display string in the standard location */

message(string)
char *string;
{
}
