/*
 * init_disp contains the initialization code for the display package
 */

#include <stdio.h>
#include "talk.h"
#include <signal.h>
#include <curses.h>
#include "curses_def.h"

int		GR_OPTION = 0 ;

char 		*current_state ;
extern int	ID;
xwin_t	        userwindow[5];
int    		curses_initialized;
int		use_height,height,width ;
int		half_horiz, half_vert ;
int		talk_win_lines, talk_win_cols ;

/* 
 * set up curses, catch the appropriate signals, and build the
 * various windows
 */

init_disp()
{	int i, t;

    	void sig_sent();

    initscr();
    curses_initialized = 1;

    height = LINES ; width = COLS ; 
    use_height = height - 2 ;

    half_horiz = (use_height) / 2 ;
    half_vert = (width) / 2 ;

    talk_win_lines = ((use_height-2) / 2) - 1 ;
    talk_win_cols = ((width-2) / 2) - 1 ;

    clear();
    refresh();

    noecho();
    crmode();

    signal(SIGINT, sig_sent);
    signal(SIGPIPE, sig_sent);


    userwindow[0].nlines = height;
    userwindow[0].ncols = width; 		/* THE CROSS */
    userwindow[0].start_row = 0 ;
    userwindow[0].start_col = 0 ;
    userwindow[0].cur_row = 0;
    userwindow[0].cur_col = 0 ;
    userwindow[0].win = newwin(height, width, 0,0);





    userwindow[1].nlines = talk_win_lines ;
    userwindow[1].ncols = talk_win_cols ;	/* TOP LEFT */
    userwindow[1].start_row = 0 ;
    userwindow[1].start_col = 0 ;
    userwindow[1].cur_row = 0 ;
    userwindow[1].cur_col = 0;
    userwindow[1].win = newwin(talk_win_lines, talk_win_cols,1,1);



    
    userwindow[2].nlines = talk_win_lines ;
    userwindow[2].ncols = talk_win_cols ;	/* TOP RIGHT */
    userwindow[2].start_row = 0 ;
    userwindow[2].start_col = 0;
    userwindow[2].cur_row = 0;
    userwindow[2].cur_col = 0;
    userwindow[2].win = newwin(talk_win_lines, talk_win_cols,1,half_vert+1); 



    
    userwindow[3].nlines = talk_win_lines ;
    userwindow[3].ncols = talk_win_cols ;	/* BOTTOM LEFT */
    userwindow[3].start_row = 0;
    userwindow[3].start_col = 0;
    userwindow[3].cur_row = 0;
    userwindow[3].cur_col = 0;
    userwindow[3].win = newwin(talk_win_lines, talk_win_cols,half_horiz+1,1); 
    


    userwindow[4].nlines = talk_win_lines ;
    userwindow[4].ncols = talk_win_cols ;	/* BOTTOM RIGHT */
    userwindow[4].start_row = 0;
    userwindow[4].start_col = 0;
    userwindow[4].cur_row = 0;
    userwindow[4].cur_col = 0;
    userwindow[4].win = newwin(talk_win_lines, talk_win_cols,half_horiz+1,half_vert+1);

    for (i=0; i<5; i++){ 
    	scrollok(userwindow[i].win, FALSE);
    	wclear(userwindow[i].win);
    }



draw_text_box(userwindow[0].win,0,0,use_height,width) ;

for ( i = 1 ; i < (width) ; i++ ) {
	wmove(userwindow[0].win, half_horiz,i);
	wprintw(userwindow[0].win, "-");
}

for ( i = 0 ; i < (use_height-1) ; i++ ) {
	wmove(userwindow[0].win,i,half_vert);
	wprintw(userwindow[0].win, "|");
}


wmove(userwindow[0].win,half_horiz,half_vert);
wprintw(userwindow[0].win,"+") ;
wmove(userwindow[0].win,half_horiz,0) ;
wprintw(userwindow[0].win,"+") ;
wmove(userwindow[0].win,half_horiz,(width-1)) ;
wprintw(userwindow[0].win,"+") ;
wmove(userwindow[0].win,0,half_vert) ;
wprintw(userwindow[0].win,"+") ;
wmove(userwindow[0].win,(use_height-1),half_vert) ;
wprintw(userwindow[0].win,"+") ;

wmove(userwindow[0].win,height-1,1);
wrefresh(userwindow[0].win);
fflush(stdout) ;


current_state = "No connection yet";
status("wait...");
}


status(msg)
char	msg[80] ;
{
	int i;

    wmove(userwindow[0].win,LINES-1,1);
    wclrtoeol(userwindow[0].win);
    wmove(userwindow[0].win,LINES-1,1);
    wprintw(userwindow[0].win,msg);
    wrefresh(userwindow[0].win);
}


void sig_sent()
{
    message("Connection closing. Exiting");
    quit();
}






/*
 * All done talking...hang up the phone and reset terminals
 */
quit()
{       int i;

  	if (curses_initialized) {
	    for (i=0; i<5; i++){
 	       wmove(userwindow[i].win, userwindow[i].nlines, 0);
	       wclrtoeol(userwindow[i].win);
	       wrefresh(userwindow[i].win);
	    };
	    endwin();
	}
  

	if (invitation_waiting) {
	    send_delete();
	}

	exit(0);
}



draw_box(win,y,x,height,width)
WINDOW *win;
int y, x, height, width;
{
     int i;

     mvwaddch(win,y,x,TL_CORNER);
     for (i = 1; i < (width-1); i++)  {
          mvwaddch(win,y,x+i,H_LINE);
     }
     mvwaddch(win,y,x+width-1,TR_CORNER);
     for (i = 1; i < (height-1); i++)  {
          mvwaddch(win,y+i,x+width-1,V_LINE);
     }
     mvwaddch(win,y+height-1,x+width-1,BR_CORNER);
     for (i = 1; i < (width-1); i++)  {
          mvwaddch(win,y+height-1,x+width-1-i,H_LINE);
     }
     mvwaddch(win,y+height-1,x,BL_CORNER);
     for (i = 1; i < (height-1); i++)  {
          mvwaddch(win,y+height-1-i,x,V_LINE);
     }
}



draw_text_box(win,y,x,height,width)
WINDOW *win;
int y, x, height, width;
{
     int i;


     wmove(win,y,x);
     wprintw(win,"+");
     for (i = 1; i < (width-1); i++)  {
          wmove(win,y,x+i);
     	  wprintw(win,"-");
     }
     wmove(win,y,x+width-1);
     wprintw(win,"+");
     for (i = 1; i < (height-1); i++)  {
          wmove(win,y+i,x+width-1);
     	  wprintw(win,"|");
     }
     wmove(win,y+height-1,x+width-1);
     wprintw(win,"+");
     for (i = 1; i < (width-1); i++)  {
          wmove(win,y+height-1,x+width-1-i);
     	  wprintw(win,"-");
     }
     wmove(win,y+height-1,x);
     wprintw(win,"+");
     for (i = 1; i < (height-1); i++)  {
          wmove(win,y+height-1-i,x);
     	  wprintw(win,"|");
     }
}


