#include "common.h"

main(argc, argv)
char **argv;
{
	int thirty;
	char c, user[16];
	int fd, i;

	if (argc < 3)
	{
usage:
		fprintf(stderr, "usage: %s [-u user] host cmd [parms]\n", argv[0]);
		exit(-1);
	}

	user[0] = 0;

	if (argv[1][0] == '-')
		switch(argv[1][1])
		{
		case 'u':
			strncpy(user, argv[2], 15);
			user[15] = 0;
			argv += 2;
			argc -= 2;
			if (argc < 3)
				goto usage;
			break;
		default:
			fprintf(stderr, "-%c flag unknown\n", argv[1][1]);
			break;
		}

	thirty = 30;

	fd = clientsock(argv[1], SUPERPORT);
	if (fd < 0)
	{
		switch(fd) {
		case -9999:
			fprintf(stderr, "%s: host unknown\n", argv[1]);
			break;
		case -ECONNREFUSED:
			fprintf(stderr, "No services on %s\n", argv[1]);
			break;
		default:
			perror("clientsock");
			break;
		}
		exit(-1);
	}

	setsockopt(fd, SOL_SOCKET, SO_LINGER, &thirty, sizeof(thirty));

	do
		read(fd, &c, 1);
	while (c != '\n');

	writeln(fd, argv[2]);
	writeln(fd, user);

	if (argc > 3)
		for (i=3; i<argc; i++)
			writeln(fd, argv[i]);

	writeln(fd, "");

	shuffle(fd);

	fcntl(0, F_SETFL, 0);
	close(fd);
}

writeln(fd, string)
int fd;
char *string;
{
	write(fd, string, strlen(string));
	write(fd, "\n", 1);
}

/*
 * Shuffle bytes between stdin/out and the socket.  This forks off
 * once so that one process handles dataflow in each direction (that's
 * how rsh does it, and it makes the code a lot prettier...)
 */
shuffle(subsrv)
int subsrv;		/* this will probably always be 3... */
{
	fd_set reed, tread, other;
	int pid, numread, buf[BUFSIZ];

	pid = fork();
	if (pid < 0)
	{
		perror("fork");
		close(subsrv);
		exit(-1);
	}

	FD_ZERO(&reed);
	FD_ZERO(&other);

	if (!pid)
	{
		close(1);
		close(2);

		while (1)
		{
			numread = read(0, buf, sizeof(buf));
			if (numread <= 0)
				break;
			write(subsrv, buf, numread);
		}
		close(subsrv);
		exit(0);
	}
	else
	{
		close(0);
		close(2);

		while (1)
		{
			numread = read(subsrv, buf, sizeof(buf));
			if (numread <= 0)
				break;
			write(1, buf, numread);
		}

		kill(pid, SIGKILL);
	}
}

