#include "common.h"

extern int errno;

/*
 * SuperServer.
 */

#define WELCOME	"SuperServer -- enter service desired.\n"
#define NOSERV	"Service not offered.\n"

int thirty;

/*
 * This structure is used to keep the database of available services.
 */
struct service {
	char	name[20];	/* Service name */
	int	fd;		/* File descriptor that offers it */
	struct service *next;	/* Next service in list */
} *list = (struct service *)0;

char users[NOFILE][16];		/* user connected to each fd */

main(argc, argv)
char **argv;
{
	struct itimerval it;		/* Alarm! */
	int	fd_so,			/* Socket() file descriptor */
		fd_co;			/* Connected file descriptor */
	short	portno;			/* Port number to listen on */
	char	request[80];
	extern int sigchld();

/*
 * First things first: put ourselves in the background.
 */
	if (fork())
		exit(0);

	portno = SUPERPORT;
	thirty = 30;

/*
 * Set up the server socket on the appropriate port number and listen on it.
 */
	fd_so = serversock(portno);
	if (fd_so < 0)
	{
		perror("serversock");
		exit(-1);
	}

	(void)listen(fd_so, 5);
	setsockopt(fd_so, SOL_SOCKET, SO_LINGER, &thirty, sizeof(thirty));
	fcntl(fd_so, F_SETOWN, getpid());

/*
 * And we'll need to accomodate child processes...
 */
	signal(SIGCHLD, sigchld);

/*
 * Now keep accepting connections and interpreting them.
 */
	while (1)
	{
		fd_co = getcon(fd_so);

		if (fd_co < 0)
		{
			perror("accept");
			exit(0);
		}

		fcntl(fd_co, F_SETOWN, getpid());
		setsockopt(fd_co,SOL_SOCKET,SO_LINGER,&thirty, sizeof(thirty));

		do {
			write(fd_co, WELCOME, sizeof(WELCOME)-1);
		} while (! getline(fd_co, request, sizeof(request)-1));

		if (handle(fd_co, request))
			close(fd_co);
	}
}

/*
 * Get a connection, or handle a disconnected server.
 */
getcon(old)
int old;
{
	struct	service *cur;
	fd_set	reed, tread, other;
	int	firstfd;

	FD_ZERO(&reed);
	FD_ZERO(&other);

	for (cur = list; cur; cur = cur->next)
		FD_SET(cur->fd, &reed);
	FD_SET(old, &reed);

	while (1)
	{
		tread = reed;
		select(NOFILE, &tread, &other, &other, 0);
		if (FD_ISSET(old, &tread))
			break;
		while (firstfd = ffs(tread))
		{
			killfd(--firstfd);
			close(firstfd);
			FD_CLR(firstfd, &tread);
			FD_CLR(firstfd, &reed);
		}
	}
	return( accept(old, 0, 0) );
}


/*
 * Get an input line from a file descriptor.  This is probably very slow.
 * Since it's only called once, though...
 */
getline(fd, buf, len)
int fd, len;
char *buf;
{
	int	index = 0;
	char	c;

	while (read(fd, &c, 1) == 1)
	{
		if (c == '\n')
			break;

		if (c == '\r')
			continue;

		if (index < len)
			buf[index++] = c;
	}

	buf[index] = 0;
	return index;
}


/*
 * Handle a user request.  This will either be "REGISTER" or some
 * user-defined function.
 */
handle(fd, string)
int fd;
char *string;
{
	struct service *cur;
	char user[16];

/*
 * If a subserver wants to register itself, grab service
 * names from it until it outputs an empty line.
 */
	if (!strcmp(string, "REGISTER"))
	{
		char name[20];

		if (! getline(fd, users[fd], 15))
			return 1;

		while (getline(fd, name, 19))
		{
			cur = (struct service *)malloc(sizeof(*cur));
			strcpy(cur->name, name);
			cur->fd = fd;
			cur->next = list;
			list = cur;
		}
		return 0;	/* Keep file descriptor open */
	}

	getline(fd, user, 15);

	if (!strcmp(string, "LIST"))
	{
		char buf[80];

		write(fd, "Username\tService\n--------\t-------\n", 34);

		for (cur = list; cur; cur = cur->next)
		{
			if (user[0] && strcmp(user, users[cur->fd]))
				continue;
			sprintf(buf, "%-8s\t%s\n", users[cur->fd], cur->name);
			write(fd, buf, strlen(buf));
		}
		return 1;
	}

	for (cur = list; cur; cur=cur->next)
		if (! strcmp(string, cur->name))
			if ((! user[0]) || (! strcmp(user, users[cur->fd])))
				break;

	if (! cur)
	{
		write(fd, NOSERV, sizeof(NOSERV));
		return 1;
	}

	write(cur->fd, string, 20);

	shuffle(cur->fd, fd);

	return 1;
}

sigchld()
{
	wait(0);
}

/*
 * Kill all entries in the linked list with a certain file
 * descriptor.
 */
killfd(fd)
int fd;
{
	struct service *cur, *temp;

	while (list && list->fd == fd)
	{
		temp = list->next;
		free(list);
		list = temp;
	}

	if (list)
		for (cur = list; cur; cur = cur->next)
			while (cur->next && cur->next->fd == fd)
			{
				temp = cur->next;
				cur->next = cur->next->next;
				free(temp);
			}
}


/*
 * This is the kludgy part.  We want to effectively connect the
 * client and the appropriate subserver.  Since there's no way to
 * connect two sockets together, we have to fork off a child and
 * sit there shuffling bytes back and forth between the two file
 * descriptors.  When one of them shuts down, we shut the other one
 * down and die.
 *
 * For now, since only one client can be talking to each subserver
 * at a given time, we erase all the subserver's services from the
 * service list.  It will reconnect when it's done.
 */
#ifndef MIN
#define MIN(x,y)	(((x)>(y))?(y):(x))
#endif

shuffle(subsrv, client)
int subsrv, client;
{
	int		fd;
	fd_set		reed, rite, except;
	extern void	quit();

	killfd(subsrv);

	if (fork())
	{
		close(subsrv);
		return;
	}

	for (fd = 0; fd < NOFILE; fd++)
		if (fd != client && fd != subsrv)
			close(fd);

	FD_ZERO(&reed);
	FD_SET(client, &reed);
	FD_SET(subsrv, &reed);
	FD_ZERO(&rite);
	except = reed;

	fcntl(client, F_SETOWN, getpid());
	fcntl(subsrv, F_SETOWN, getpid());
/*	fcntl(client, F_SETFL, FNDELAY);
	fcntl(subsrv, F_SETFL, FNDELAY);
*/

	signal(SIGURG, quit);
	signal(SIGPIPE, quit);

	while (1)
	{
		fd_set	tread, twrite, texcept;
		int	numbytes, bsize, numread, zero = 0;
		char	buf[4096];

		tread = reed;
		twrite = rite;
		texcept = except;

		select(NOFILE, &tread, &twrite, &texcept, (void *)0);

		if (FD_ISSET(subsrv, &tread))
		{
			ioctl(subsrv, FIONREAD, &numbytes);
			bsize = MIN(numbytes, sizeof(buf));
			numread = read(subsrv, buf, bsize);
			if (numread < 0 && errno != EWOULDBLOCK)
			{
				perror("subsrv");
				exit(0);
			}
			if (! numread)
			{
				shutdown(client, 1);
				shutdown(subsrv, 0);
				FD_CLR(subsrv, &reed);
			}
			else
				write(client, buf, numread);
		}

		if (FD_ISSET(client, &tread))
		{
			ioctl(client, FIONREAD, &numbytes);
			bsize = MIN(numbytes, sizeof(buf));
			numread = read(client, buf, bsize);
			if (numread < 0 && errno != EWOULDBLOCK)
			{
				perror("client");
				exit(0);
			}
			if (! numread)
			{
				shutdown(client, 0);
				shutdown(subsrv, 1);
				FD_CLR(client, &reed);
			}
			else
				write(subsrv, buf, numread);
		}

/* If both sides were shut down, leave. */
		if (! (FD_ISSET(client, &reed) || FD_ISSET(subsrv, &reed)))
		{
			close(client);
			close(subsrv);
			exit(0);
		}

		if (FD_ISSET(client, &texcept) || FD_ISSET(subsrv, &texcept))
		{
			close(client);
			close(subsrv);
			exit(0);
		}
	}
}

void quit()
{
	exit(0);
}

