

/*
 *	$Header: asntest.c,v 1.1 89/01/11 22:11:49 jrd Exp $
 *	Author: J. Davin
 *	Copyright 1988, 1989, Massachusetts Institute of Technology
 *	See permission and disclaimer notice in file "notice.h"
 */

#include	<notice.h>

#include	<ctypes.h>
#include	<rdx.h>
#include	<debug.h>
#include	<asn.h>

int	main (argc, argv)

int	argc;
char	*argv [];

{
	AsnIdType		asn;
	AsnStatusType		status;
	CByteType		buf [ 512 ];
	CBytePtrType		cp;
	CIntfType		i;
	AsnLengthType		l;
	CUnslType		number;

	cp = buf;
	for (i = 1; i < (CIntfType) argc; i++) {
		(void) rdxDecodeAny (& number, argv [ i ]);
		*cp++ = (CByteType) number;
	}

	asn = asnNew ((AsnLanguageType) 0);

	status = asnStatusOk;
	cp = buf;
	for (i = 1; ((status == asnStatusOk) && (i < (CIntfType) argc)); i++) {
		status = asnDecode (asn, *cp);
		DEBUG2 ("%02.02X %d\n", (unsigned) *cp, status);
		cp++;
	}

	switch (status) {

	case asnStatusOk:
		DEBUG0 ("++OK\n");
		break;

	case asnStatusAccept:
		DEBUG0 ("++ACCEPT\n");
		break;

	case asnStatusReject:
		DEBUG0 ("++REJECT\n");
		break;

	case asnStatusBad:
		DEBUG0 ("++BAD\n");
		break;

	default:
		DEBUG0 ("++Panic\n");
		break;
	}

	l = asnEncode (asn, buf, (AsnLengthType) 512);
	cp = buf;
	for (i = (CIntfType) l; i > 0; i--) {
/*		DEBUG1 ("%02.02X ", *cp++);		*/
		DEBUG1 ("%d ", *cp++);
	}
	DEBUG0 ("\n");

	asn = asnFree (asn);
	exit (0);
}
