
/*
 *	$Header: systm.c,v 1.2 89/02/17 18:40:42 jrd Exp $
 *	Author: J. Davin
 *	Copyright 1988, 1989, Massachusetts Institute of Technology
 *	See permission and disclaimer notice in file "notice.h"
 */

#include	<notice.h>

#include	<sys/param.h>
#include	<sys/types.h>
#include	<sys/time.h>
#include	<nlist.h>
#include	<stdio.h>

#include	<ctypes.h>
#include	<local.h>
#include	<debug.h>
#include	<miv.h>
#include	<asn.h>
#include	<mix.h>
#include	<systm.h>
#include	<kmem.h>

#define			systmStringSize		(2 * MAXHOSTNAMELEN)

static	CCharType	systmDescrText [ systmStringSize ];
static	CCharType	systmHostName [ (MAXHOSTNAMELEN + 1) ];
static	MivStrType	systmDescrStr;

static	CByteType	systmObjId [ systmStringSize ];
static	MivStrType	systmIdStr;

static	struct	timeval	systmBootTime;

static	MixStatusType	systmTimeRelease (mix)

MixCookieType		mix;

{
	mix = mix;
	return (smpErrorGeneric);
}


static	MixStatusType	systmTimeNoSet (mix, name, namelen, value)

MixCookieType		mix;
MixNamePtrType		name;
MixLengthType		namelen;
AsnIdType		value;

{
	mix = mix;
	name = name;
	namelen = namelen;
	value = value;
	return (smpErrorReadOnly);
}

static	MixStatusType	systmTimeCreate (mix, name, namelen, value)

MixCookieType		mix;
MixNamePtrType		name;
MixLengthType		namelen;
AsnIdType		value;

{
	mix = mix;
	name = name;
	namelen = namelen;
	value = value;
	return (smpErrorGeneric);
}

static	MixStatusType	systmTimeDestroy (mix, name, namelen)

MixCookieType		mix;
MixNamePtrType		name;
MixLengthType		namelen;

{
	mix = mix;
	name = name;
	namelen = namelen;
	return (smpErrorGeneric);
}

static	AsnIdType	systmTimeGet (mix, name, namelen)

MixCookieType		mix;
MixNamePtrType		name;
MixLengthType		namelen;

{
	struct	timeval		now;
	CUnslType		uptime;

	mix = mix;
	if ((namelen != (MixLengthType) 1) ||
		(*name != (MixNameType) 0)) {
		return ((AsnIdType) 0);
	}
	else {
		(void) gettimeofday (& now, (struct timezone *) 0);
		uptime = (CUnslType) (now.tv_sec - systmBootTime.tv_sec) *
			(CUnslType) 100;
		return (asnUnsl (asnClassApplication, (AsnTagType) 3, uptime));
	}
}

static	AsnIdType	systmTimeNext (mix, name, namelenp)

MixCookieType		mix;
MixNamePtrType		name;
MixLengthPtrType	namelenp;

{
	struct	timeval		now;
	CUnslType		uptime;

	mix = mix;
	if (*namelenp != (MixLengthType) 0) {
		return ((AsnIdType) 0);
	}
	else {
		*namelenp = (MixLengthType) 1;
		*name = (MixNameType) 0;
		DEBUG2 ("systmTimeNext: boot %d %d\n",
			systmBootTime.tv_sec,
			systmBootTime.tv_usec);
		(void) gettimeofday (& now, (struct timezone *) 0);
		DEBUG2 ("systmTimeNext: now %d %d\n",
			now.tv_sec,
			now.tv_usec);
		uptime = (CUnslType) (now.tv_sec - systmBootTime.tv_sec) *
			(CUnslType) 100;
		DEBUG1 ("systmTimeNext: uptime %d\n", uptime);
		return (asnUnsl (asnClassApplication, (AsnTagType) 3, uptime));
	}
}

static	MixOpsType	systmTimeOps	= {

			systmTimeRelease,
			systmTimeCreate,
			systmTimeDestroy,
			systmTimeNext,
			systmTimeGet,
			systmTimeNoSet

			};

CVoidType		systmInit ()

{
	long		gethostid ();
	int		gethostname ();
	long		hostid;
	struct	nlist	nl [ 2 ];

	CCharType	playArea [ systmStringSize ];
	CIntfType	k;

	if (gethostname ((char *) systmHostName, (int) MAXHOSTNAMELEN) < 0) {
		(void) sprintf (systmDescrText, "Unknown BSD Unix Host");
	}
	else {
		systmHostName [ MAXHOSTNAMELEN ] = (CCharType) 0;
		(void) sprintf (systmDescrText, "BSD Unix Host %s",
			systmHostName);
	}

	systmDescrStr.mivStrData = (CBytePtrType) systmDescrText;
	systmDescrStr.mivStrMaxLen = (CUnsfType) systmStringSize;
	systmDescrStr.mivStrLen = (CUnsfType) strlen (systmDescrText);

	(void) mivStringRO ((MixNamePtrType) "\53\6\1\2\1\1\1",
		(MixLengthType) 7, & systmDescrStr);

	hostid = gethostid ();
	DEBUG1 ("systmInit: Hostid %d\n", hostid);
	/* enterprises 1.3.6.1.4.1; mit 20; lcs 1	*/
	(void) sprintf (playArea, "1.3.6.1.4.1.20.1.%u", hostid);
	k = oidEncode (systmObjId, (CIntfType) systmStringSize, playArea);
	if (k > (CIntfType) 0) {
		systmIdStr.mivStrData = systmObjId;
		systmIdStr.mivStrMaxLen = (CUnsfType) systmStringSize;
		systmIdStr.mivStrLen = (CUnsfType) k;

		(void) mivObjectIdRO ((MixNamePtrType) "\53\6\1\2\1\1\2",
			(MixLengthType) 7, & systmIdStr);
	}

	nl [ 0 ].n_name = "_boottime";
	nl [ 1 ].n_name = (char *) 0;

	if (nlist ("/vmunix", nl) == 0) {
		(void) kmemRead ((CBytePtrType) & systmBootTime,
			(CIntfType) sizeof (systmBootTime),
			(CUnslType) nl [ 0 ].n_value);
	}
	else {
		systmBootTime.tv_sec = (long) 0;
		systmBootTime.tv_usec = (long) 0;
	}

	(void) misExport ((MixNamePtrType) "\53\6\1\2\1\1\3",
		(MixLengthType) 7, & systmTimeOps, (MixCookieType) 0);
}

