
/*
 *	$Header: avltest.c,v 1.1 89/01/11 22:11:55 jrd Exp $
 *	Author: J. Davin
 *	Copyright 1988, 1989, Massachusetts Institute of Technology
 *	See permission and disclaimer notice in file "notice.h"
 */

#include	<notice.h>

#include	<stdio.h>

#include	<ctypes.h>
#include	<rdx.h>
#include	<avl.h>
#include	<local.h>

int		rand ();
int		srand ();

AvlBalanceType		nodeCmp (a, b, n)

AvlInfoType		a;
AvlNamePtrType		b;
AvlLengthType		n;

{
	int		cmp;
	AvlBalanceType	result;

	n = n;
	cmp = strcmp ((char *) a, (char *) b);
	if (cmp > 0) {
		result = avlDirLeft;
	}
	else if (cmp < 0) {
		result = avlDirRight;
	}
	else {
		result = avlDirBalanced;
	}
	return (result);
}

CBytePtrType		randString (n)

CIntfType		n;

{
	CUnsfType		len;
	CBytePtrType		item;
	CBytePtrType		cp;

	while ((len = rand () % n) == 0);
	item = (CBytePtrType) malloc ((unsigned) (len + 1));
	if (item != (CBytePtrType) 0) {
		cp = item;
		while (len-- != 0) {
			*cp++ = (CByteType) ((rand () % 26) + 'A');
		}
		*cp = (CByteType) 0;
	}

	return (item);
}

AvlStatusType		stringPrint (x)

AvlInfoType		x;

{
	printf ("%s", (char *) x);
	return (errOk);
}

#define		TESTSIZE	100

int	main (argc, argv)

int		argc;
char		*argv [];

{
	AvlIdType		tree;
	CBytePtrType		info;
	AvlInfoType		find;
	CIntfType		i;
	CIntfType		filter;
	CIntfType		testsize;
	CIntfType		howmany;
	AvlStatusType		status;
	CBytePtrType		inputs [ TESTSIZE + 1 ];
	CUnslType		number;

	if (argc < 2) {
		printf ("usage: %s [ testsize ] < seed > < filter >\n",
			argv [ 0 ]);
		exit (1);
	}

	if (rdxDecodeAny (& number, argv [ 1 ]) < (CIntfType) 0) {
		printf ("%s: bad testsize %s\n", argv [ 0 ], argv [ 1 ]);
		exit (2);
	}
	testsize = (CIntfType) number;
	if (testsize > TESTSIZE) {
		printf ("%s: testsize < %d\n", argv [ 0 ], TESTSIZE);
		exit (2);
	}

	if (argc > 2) {
		if (rdxDecodeAny (& number, argv [ 2 ]) < (CIntfType) 0) {
			printf ("%s: bad seed %s\n", argv [ 0 ],
				argv [ 2 ]);
			exit (2);
		}
		(void) srand ((int) number);
	}

	if (argc > 3) {
		if (rdxDecodeAny (& number, argv [ 3 ]) < (CIntfType) 0) {
			printf ("%s: bad filter %s\n", argv [ 0 ],
				argv [ 3 ]);
			exit (2);
		}
		filter = (CIntfType) number;
	}
	else {
		filter = (CIntfType) 0;
	}

	tree = avlNew (nodeCmp, stringPrint);
	status = errOk;

	for (i = testsize; (i != 0) && (status == errOk); i--) {
		info = randString (29);
		inputs [ i ] = info;
		status = avlInsert (tree, (AvlNamePtrType) info,
			(AvlLengthType) strlen ((char *) info),
			(AvlInfoType) info);
		printf ("avlInsert: tree %08.08X info %s\n", tree, info);
	}

	printf ("status: %d\n", status);
	printf ("\n");
	(void) fflush (stdout);

	howmany = testsize - ((i != 0) ? i + 1 : 0);

	for (i = howmany; (i != 0); i--) {
		info = inputs [ i ];
		find = avlFind (tree, (AvlNamePtrType) info,
			(AvlLengthType) strlen ((char *) info));
		if (strcmp ((char *) find, (char *) info) != 0) {
			printf ("avlFind: find %s info %s\n", find, info);
		}
	}

	info = (CBytePtrType) "";

	while ((find = avlCessor (tree, (AvlNamePtrType) info,
		(AvlLengthType) strlen ((char *) info))) !=
		(AvlInfoType) 0) {
		printf ("avlCessor: %s\n", (char *) find);
		info = (CBytePtrType) find;
	}
	
	status = errOk;

	for (i = testsize; (i != 0) && (status == errOk); i--) {
		if ((rand () & filter) == 0) {
			info = inputs [ i ];
			status = avlRemove (tree, (AvlNamePtrType) info,
				(AvlLengthType) strlen ((char *) info));
			printf ("avlRemove: tree %08.08X info %s\n",
				tree, info);
		}
	}

	printf ("status: %d\n", status);

}

