#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include "inet.h"

#define MAXHOSTNAMELENGTH 255
char hostname[MAXHOSTNAMELENGTH];

extern errno;
static int maxfds;
static struct timeval zerotime;

int		/* returns a socket, or -1 for failure */
initport(porttype,port_name,port_number,role,sockettype,host_in)
int porttype;
char *port_name;
u_short port_number;
int role;
int sockettype;
char *host_in;			/* host to provide service */
{
    int s;		/* the socket */
    struct sockaddr_in sin;
    struct hostent *h;
    struct servent *sp;	/* used by getservbyname - may not be nec. */

    maxfds = getdtablesize();	/* for future reference */
    zerotime.tv_sec = zerotime.tv_usec = 0L;

    if (client) {
	if (host_in && strcmp(host_in,"")) strcpy(hostname,host_in);
	else {
	    if (gethostname(hostname,MAXHOSTNAMELENGTH)) {
		fprintf(stderr,"gethostname() failed\n");
		perror("initport(client)");
		return(-1);
	    }
	}

	if (!(h = gethostbyname(hostname))) {
	    fprintf(stderr,"gethostbyname() failed\n");
	    perror("initport(client)");
	    return(-1);
	}
    }

    if (porttype == PORT_TYPE_NAME) {
	if (!(sp = getservbyname(port_name,NULL))) {
            fprintf(stderr,"getservbyname() failed to find %s\n",port_name);
            exit(-1);
	}
    }

    if (-1 == (s = socket(AF_INET,sockettype,0))) {
	fprintf(stderr,"socket() failed\n");
	perror("initport");
	return(-1);
    }

    sin.sin_family = AF_INET;
    sin.sin_addr.s_addr = (server?INADDR_ANY:*(u_long *) h->h_addr);
    sin.sin_port = (porttype == PORT_TYPE_NAME?sp->s_port:port_number);

    if (client) {
	if (connect(s,(struct sockaddr *)&sin,sizeof(struct sockaddr_in))) {
	    fprintf(stderr,"connect() failed\n");
	    perror("initport(client)");
	    return(-1);
	}
    } else {
	/* bind the socket */
	/* following line is for debugging, see IPC primer, p. 25 */
	setsockopt(s,SOL_SOCKET,SO_REUSEADDR,(char *)0,0);
	if (-1 == (bind(s,(struct sockaddr *)&sin,sizeof(sin)))) {
		fprintf(stderr,"bind() failed\n");
		perror("initport(server)");
		return(-1);
	}
	if (listen(s,1)) {
		perror("listen");
		return(-1);
	}
    }
    return(s);
}

select_server_stream(connection_socket,readers)
int connection_socket;
int *readers;	/* file descriptors of client sockets */
{
    struct sockaddr_in from;
    int fromlen;
    static int fd;	/* next file descriptor to look at */
    int readfds, c;
    int user;

    /* how do you get sockets to block?  there is some hint (recv(2)) */
    /* in the manual that you can but I can't find the reference! */

    /* select does not like bogus file descriptors, so keep track of */
    /* them by hand */
    *readers |= 1<<connection_socket;

restart:
    do {
	/* save readers because select wipes them out */
	readfds = *readers;
	c = select(maxfds,&readfds,(int *)0,(int *)0,(struct timeval *)0);
	if (c == -1) {
	    if (errno == EBADF) {
		int i, suspect;
		/* someone augered in, lets forget about'm */
		for (i=0;i<maxfds;i++) {
		    if ((1<<i) & *readers) {
			/* use a temporary for the suspect because select() */
			/* requires an address */
			suspect = 1<<i;
			if (-1 == select(maxfds,&suspect,(int *)0,(int *)0,
								&zerotime)) {
			    /* found a reader who closed his socket */
			    /* so get rid of him */
			    *readers &= ~(1<<i);
			}
		    }
		}
	    } else {
		/* lets hope it was a recoverable interrupt and try again */
		perror("select");
		exit(-1);
	    }
	}
    } while (c == -1);
    /* given the set of ready file descriptors pick one out that is ready */
    /* start from where we left off, so as to give everyone service */
    while (!(readfds & 1<<(fd = (1+fd)%maxfds))) ;

    if (fd == connection_socket) {	/* check for new connections */
	fromlen = sizeof(from);
	user = accept(connection_socket,(struct sockaddr *)&from,&fromlen);
	*readers |= 1<<user;
	goto restart;
    }

    return(fd);
}

print_address(x)
struct sockaddr_in *x;
{
	printf("x->sin_family = %d\n",(int)x->sin_family);
	printf("x->sin_port = %d\n",(int)x->sin_port);
	printf("x->sin_addr.s_addr = %d\n",(int)x->sin_port);
	printf("x->sin_zero[0] = %c\n",x->sin_zero[0]);
}
