/* usr_var.c - utility functions for user only! */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <strings.h>

#include "cm_constants.h"
#include "cm_sd.h"
#include "cm_interface.h"

cm_variable cm_variables[CM_MAXUSERVARIABLES];

cm_variable *
get_variable(name)
char *name;
{
        int i;

	eprintf(10,"entering get_variable(%s)\n",name);
        for (i=0;i<CM_MAXUSERVARIABLES;i++) {
                /* create it if we come to an empty variable */
                if (!cm_variables[i].status.inuse) {
		    eprintf(10,"get_variable: found empty variable slot\n");
                    strcpy(cm_variables[i].name,name);
		    cm_sd_clear(&cm_variables[i].data);
		    cm_variables[i].role.reader = 0;
		    cm_variables[i].role.nonxwriter = 0;
		    cm_variables[i].role.wakeup = 0;
		    cm_variables[i].role.xwriter = 0;
		    cm_variables[i].old_count = 0;
		    cm_variables[i].count = 0;
		    cm_variables[i].command_association = 0;
		    cm_time_zero(&cm_variables[i].timestamp);
		    cm_variables[i].status.inuse = TRUE;
		    cm_variables[i].status.written = FALSE;
		    cm_variables[i].status.declared = FALSE;
                    return(&cm_variables[i]);
                }
                /* found an old definition */
                if (!(strcmp(cm_variables[i].name,name))) {
			eprintf(10,"get_variable() found old defn\n");
                        return(&cm_variables[i]);
                }
        }
        /* no old definition and no space for a new one!!!! */
        return(NULL);
}

/*
The following function allows the user to step through all the common
memory values, for example, to see if any have changed.  If v is NULL,
the first value is returned.  If no more cm_variables are in use, NULL is
returned.

This function is also used by the common memory system itself, as it
hides the implementation of the user cm_variables as a large array.
Presumably, it will be changed to have a hash index in the future
for speed.
*/
cm_variable *
next_user_variable(v)
cm_variable *v;	/* if NULL, start from the beginning */
{
	if (v == 0) v = cm_variables;	/* reinitialize */
	else v++;			/* next one */

	for (;v<&cm_variables[CM_MAXUSERVARIABLES];v++) {
		if (v->status.inuse) return(v);
	}
	return((cm_variable *)NULL);
}
