
/*

These routines build slots for the user.  These slots are placed into a
msg structure and sent to the cmm.  The all return 0 for failure, or a
positive number indicating the number of bytes in the slot.

*/

#include <stdio.h>
#include <sys/time.h>
#include "cm_constants.h"
#include "cm_sd.h"
#include "cm_slot.h"
#include "cm_msg.h"
#include "cm_bytestuff.h"
#include "cm_interface.h"

/* this indicates that the user wants the cmm to send back the latest value */
/* of all variables */
put_slot_read(m)
struct msg *m;
{
	struct slot s;
	unsigned int size;

	init_slot(&s,"read all",CM_SLOT_READ);
	size = align(sizeof(struct slot_hdr));
/*	size += align(sizeof(struct slot_read));*/
	return(finish_slot(m,&s,size));
}

int	/* returns size of data written in msg */
put_slot_write(m,name,data,cmd)
struct msg *m;
char *name;
cm_value *data;
int cmd;
{
	struct big_slot s;
	unsigned int size;

	init_slot((struct slot *)&s,name,CM_SLOT_WRITE);
	size = align(sizeof(struct slot_hdr));
	size += align(sizeof(struct slot_write_hdr));
	s.subslot.write.sw_command_association = cmd;
	size += cm_sd_to_flat(data,&s.subslot.write.fdata);
	return(finish_slot(m,(struct slot *)&s,size));
}

int
put_slot_declare(m,name,role,cmd_assoc)
struct msg *m;
char *name;
struct usr_var_role *role;
int cmd_assoc;
{
	struct slot s;
	unsigned int size;

	init_slot(&s,name,CM_SLOT_DECLARE);
	size = align(sizeof(struct slot_hdr));
	size += align(sizeof(struct slot_declare));
	/* could do some checking on the following */
	s.subslot.declare.role.reader = role->reader;
	s.subslot.declare.role.wakeup = role->wakeup;
	s.subslot.declare.role.xwriter = role->xwriter;
	s.subslot.declare.role.nonxwriter = role->nonxwriter;
	s.subslot.declare.command_association = cmd_assoc;
	return(finish_slot(m,&s,size));
}

int
put_slot_undeclare(m,name)
struct msg *m;
char *name;
{
	struct slot s;
	unsigned int size;

	init_slot(&s,name,CM_SLOT_UNDECLARE);
	size = align(sizeof(struct slot_hdr));
/*	size += align(sizeof(struct slot_undeclare));*/
	return(finish_slot(m,&s,size));
}
