/*

these functions are used by the user to read and process information from
incoming slots 

*/

#include <stdio.h>
#include <sys/time.h>
#include "cm_constants.h"
#include "cm_sd.h"
#include "cm_interface.h"
#include "cm_slot.h"

cm_variable *get_variable();

user_decode_slot(s)
struct slot *s;
{
	int rc = 0;

	switch (s->s_type) {
	case CM_SLOT_READ_RESPONSE:
		rc = get_slot_read_response(s->s_name,
				&s->subslot.read_response);
		break;
	case CM_SLOT_ERROR:
		rc = get_slot_error(s->s_name,&s->subslot.error);
		break;
	default:
		fprintf(stderr,"user_decode_slot: unknown slot type (%d)...msg aborted\n",s->s_type);
		rc = E_CM_GET_SLOT_UNKNOWN_SLOT_TYPE;
		break;
	}
	return(rc);
}

/* returns 0 if ok, negative if problem decoding slot */
int
get_slot_error(name,s)
char *name;
struct slot_error *s;
{
	fprintf(stderr,"CMM: error processing variable <%s> - %s\n",name,
		s->msg);
	/* isn't there a "type" field in the error subslot, too? */
	return(0);
}

/* 0 if ok, negative if problem decoding slot */
int
get_slot_read_response(name,s)
char *name;
struct slot_read_response *s;
{
	int rc;
	cm_variable *v;

	if (!(v = get_variable(name))) {
		fprintf(stderr,"get_slot_read_response: <%s> unknown (sent from cm)\n",v->name);
		return(E_CM_GET_SLOT_GET_VARIABLE);
	}

	if (0 > cm_flat_to_sd(&s->fdata,&v->data))
		return(E_CM_GET_SLOT_FLAT_TO_SD);
	v->count = s->srr_count;
	v->command_association = s->srr_command_association;
	cm_time_copy(&s->srr_timestamp,&v->timestamp);
	return(0);
}
	
