/* msg.c */

#include <sys/time.h>
#include "cm_constants.h"
#include "cm_sd.h"
#include "cm_slot.h"
#include "cm_msg.h"
#include "cm_bytestuff.h"

extern int cm_debug_level;

/* returns NULL if no more slots */
struct slot *
nextslot(m,s)
struct msg *m;
struct slot *s;
{
	struct slot *next;

	next = (struct slot *)byteadd(s,s->s_size);
	if (next >= (struct slot *)byteadd(m,m->size))
		return((struct slot *)0);
	return(next);
}

print_msg(m)
struct msg *m;
{
	struct slot *s;

	eprintf(3,"msg header:");
	eprintf(3," size = %d",m->size);
	eprintf(3," slots = %d",m->slots);
	eprintf(3," name = %s",m->name);
	eprintf(3," read_wait = %d\n",m->read_wait);
	for (s=m->data;s;s=nextslot(m,s)) {
		eprintf(5,"slot: name = %s",s->s_name);
		eprintf(5," &slot = %x",s);
		eprintf(5," size = %d\n",s->s_size);
		if (s->s_size == 0) {
			eprintf(5,"0 length slot encountered in print_msg\n");
			break;
		}
	}
	if (cm_debug_level >= 10) ascii_dump((char *)m,m->size);
}

