/*					-[Sat Jun  2 08:09:36 1984 by jkf]-
 * 	module.h			$Locker:  $
 * 
 *  module interface includes
 *
 * $Header: module.h,v 40.2 84/11/13 14:23:46 schlafly Exp $
 *
 * (c) copyright 1984, Franz Inc., Oakland California
 */

/*
 * All C coded modules will contain a VERSION
 * header in which the rcs header is stored
 */
 
#ifndef lint
#define VERSION(s)	static char *rcsid = s
#else
#define VERSION(s)
#endif


/*
 * All variables are either private in the module or else are
 * shared among 2 or more files.
 * Private variables are declared Private inside the file.
 * Non-private variables are either declared Public in a .h file which
 * all files that wish to reference that variable must include,
 * or are declared Export in a C (non-header) file.  C files wishing
 * to reference those variables declare the variable Import.
 * 
 *
 * Private corresponds to 'static' in C, although it usually isn't a good
 * idea to declare variables or functions to be static if you want to debug
 * the code with something like adb.
 * Export corresponds to '' (nothing), and Import to 'extern'.
 * Public corresponds to 'extern' in C, although there must be one file
 * in which the 'extern' isn't declared.  To order to strip the extern,
 * the macro DefineData should be set before including files.
 *
 * Public should be used instead of Import and Export since it assures
 * that every module gets the same declaration.  However it does require
 * a .h file, and this may be too much effort for one or two variables.
 *
 */
 
#define Private static
#define Export
#define Import extern

#ifdef DefineData
# define Public
#else
# define Public extern
#endif
