/*					-[Wed Jun 12 07:59:36 1985 by jkf]-
 * 	global.h			$Locker:  $
 * main include file 
 *
 * $Header: global.h,v 40.27 85/06/26 14:24:02 smh Exp $
 *
 * (c) copyright 1982, Regents of the University of California
 * Enhancements (c) copyright 1984, Franz Inc., Berkeley California
 */

#include <stdio.h>

/*
** if you change VERNO, then also change the compiler version number
** in the file /usr/franz/liszt/sys/const.l
*/
/* the fasl file version number */
#define VERNO	422
/* the current opus number */
#define OPUS	42

#include "module.h"
#include "config.h"
#include "ltypes.h"
#include "lstructs.h"
#include "sigtab.h"   /* table of all pointers to lisp data */
#include "dfuncs.h"
#include "public.h"

#define FALSE	0
#define	TRUE	1
#define EVER	;;

/* used by Imakeht() and anyone who calls it */
# define HASHKEY_EQ	1
# define HASHKEY_EQUAL	2

/* STRBLEN is used in many places as a good size for a char array */ 
#define STRBLEN 512

/* LBPG is 'bytes per lisp page'. */
#define LBPG	512

#define	NULL_CHAR	0

/* maximum and minimum fixnums */
#define MaxINT 0x3fffffff
#define MinINT (- 0x4000000)

extern char unbound[];

/* 
 * macros for saving state and restoring state
 *
 * Savestack and Restorestack are required at the beginning and end of
 * functions which modify the stack pointers np and lbot.
 * The Savestack(n) should appear at the end of the variable declarations
 * The n refers to the number of register variables declared in this routine.
 * The information is required for the Vax version only.
 *** this ifdef should be broken up into ifdefs
 */
#ifndef NPINREG
extern struct atom nilatom, eofatom;
#define nil	((lispval) &nilatom)
#define eofa	((lispval) &eofatom)
#define Savestack(n) struct argent *OLDlbot = lbot, *OLDnp = np
#define Restorestack() (lbot = OLDlbot), np = OLDnp
#else
#define nil	((lispval) 0)
#define eofa	((lispval) 20)
#define Savestack(n) snpand(n)
#define Restorestack() 
#endif

#ifdef SIXONLY
#define errorh1 errh1
#define errorh2 errh2
#endif

#define	CNIL	((lispval) (OFFSET-4))
#define NOTNIL(a)	(nil!=a)
#define ISNIL(a)	(nil==a)

#ifdef SPISFP
#define initxstack()	xsp = exsp = xstack + xstksize;
extern word *xsp, *exsp, xstack[];
extern int xstksize;
#define sp() (word*)xsp
#define stack(z) (xsp > xstack ? (*--xsp = z): xserr())
#define unstack() (*xsp++)
#define Keepxs() word *oxsp = xsp;
#define Freexs() xsp = oxsp;
#else
#define initxstack()	/* nothing */
extern word *sp(), stack(), unstack();
#define Keepxs() /* */
#define Freexs() /* */
#endif

#ifdef apollo
extern char textstart[], datastart[];
extern char textend[], dataend[];
extern char heapstart[];
extern char heapend[];
#endif apollo

#define UPTR(x)	((unsigned)(((word)(x))-(word)CNIL))
#define VALID(a)	(UPTR(a) <= UPTR(datalim))

#define roundup(x,inc)	(((x - 1) | (inc - 1)) + 1)
#define NPAGES(b)	ONPAGE(roundup(b, LBPG))
#define ONPAGE(a1)	(((word) (a1)) >> 9)
#define ATOX(a1)	((((word)(a1)) - OFFSET) >> 9)

#define	TYPE(a1)	((typetable+1)[ATOX(a1)])
#define SETTYPE(s,typ)	(typetable+1)[ATOX(s)] = typ
#define	HUNKSIZE(a1)	((TYPE(a1)+5) & 15)

#define Popframe() (errp->olderrp)

/* TNP - test np to see if it has exceeded the limit of the namestack */
#define TNP	if(np >= nplim) namerr();

/*
 * protect - stack the given value on the namestack, 'protect'ing from
 * the garbage collector
 */
#define protect(p) ((np++)->val = (p))

/*
 * chkarg - If there aren't p arguments on the namestack,
 * print an argument error with x being the name of the function called.
 */
#define chkarg(p,x) if((p)!=np-lbot) argerr(x);
#define chkrange(low,high,x)	if ((np-lbot < low) || (np-lbot > high))\
					argerr(x);


/* number of counters for fasl to use in a profiling lisp  */
#define NMCOUNT 5000



/*
 * big string buffer for whomever needs it
 *** this should be in public.h but can't until we initialize the
 *** string buffer correctly.
 */
extern char	*strbuf;
extern char	*endstrb;


/*
 * PUSHDOWN stores the given 'atom' and its old value on the bindstack
 * and then sets 'atom' to 'value'
 */

#define PUSHDOWN(atom,value)\
	{bnp->atm=(atom);bnp->bindv=(atom)->a.bindv;\
	(bnp++)->val=(atom)->a.clb;(atom)->a.clb=value;\
	(atom)->a.bindv=(atom);\
	if(bnp>bnplim) binderr();}

/* PUSHDOWNB is like PUSHDOWN but allows specification of both the clb
 * and bindv of the new binding.  Presently used only for instance
 * variables during interpreted method code.
 */

#define PUSHDOWNB(atom,vclb,vbindv)\
	{bnp->atm=(atom);bnp->bindv=(atom)->a.bindv;\
	(bnp++)->val=(atom)->a.clb;(atom)->a.clb=(vclb);\
	(atom)->a.bindv=(vbindv);\
	if(bnp>bnplim) binderr();}

/*
 * POP pops off the top value on the bindstack, restoring the value
 * of the atom.
 */
    
#define POP\
	{--bnp; bnp->atm->a.clb=bnp->val; bnp->atm->a.bindv=bnp->bindv;}

/* PUSHVAL  is used to store a specific atom and value on the
 * bindstack.   Currently only used by closure code
 */  
#define PUSHVAL(atom,value)\
	{bnp->atm=(atom);bnp->bindv=(atom)->a.bindv;(bnp++)->val=value;\
	if(bnp>bnplim) binderr();}


/*
 * the Fixzero table is a table of fixnums from -1024 to 1023, with
 * Fixzero[0] being zero.  The SMALL(n) macro return the fixnum n
 */
extern word Fixzero[];
#define SMALL(i)	((lispval)(Fixzero + i))

/*
 * register lisp macros for registers only used in non-portable vax version
 * These place code in the assembler stream which tells 'fixmask'
 * to alter the register save mask
 * saveonly(n) - save the first n registers (r11,r10,...,r6)
 * snpand(n)   - save np and lbot (r6+r7) then the first n registers
 */
#ifdef NPINREG
# define saveonly(n)	asm("#save	n")
# define snpand(n)	asm("#protect	n")
#endif


/*
 * Chkint - macro to check if an interrupt has occured, and if
 * it does then to process it
 */
#define Chkint() if (sigintcnt > 0) dosigint()
