/*                                      -[Wed Jun 12 08:00:31 1985 by jkf]-
 *      config.h                        $Locker:  $
 * configuration dependent info
 *
 * $Header: config.h,v 40.37 85/07/21 10:49:29 layer Exp $
 *
 * (c) copyright 1982, Regents of the University of California
 * Enhancements (c) copyright 1984, Franz Inc., Oakland California
 */
 
/* 
 * this file contains three types of parameters
 *  1) those parameters which each site may wish to modify to
 *     personalize lisp.
 *  2) those flags which are machine or operating system dependent
 *     and thus which should not be modified.
 *  3) those which should be of type (1) but by the time the customer
 *     has received lisp, the setting of the flag has been hardwired
 *     in.  We are trying to reduce flags of this type, but a few still
 *     exist.
 *
 * In the description of each flag we will note its class from the
 * list above (class 1,2 or 3).
 *
 */

/*
** The type of machine and os this is to run on will come from
** the file lconf.h.  
*/
# ifndef NoLconf
#  include "lconf.h"
# endif


/* GCSTRINGS - (class 3)
 *  define this if you want the garbage collector to reclaim
 *  strings.  It is not normally set because in typical applications the
 *  expense of collecting strings is not worth the amount of space
 *  retrieved
 */
 
/* #define GCSTRINGS */

/*
 * NAMESIZE (class 1) - size of the internal stack for holding
 * local (non-special) variables.  The size allocated is
 * NAMESIZE + 4*NAMEINC, the stack growing by NAMINC each
 * time it overflows (so that overflows can be handled in lisp).
 * NAMINC is a class 1 constant.
 */
#define NAMESIZE 3072
#define NAMINC 50

/*
 * MVR (class 3)  handle multiple value returns
 */
#define MVR
#define MMVR 20

/*
** HASHT (class 3) include the hash table package
*/
#define HASHT

/* DOMAIN - (class 3) this is put on the (status features) list and
 *      is the value of (status domain)
 */
#define DOMAIN  "franz-inc"

/*
 * Machine/os dependent flags:          (class 2)
 * All flags are of the ifdef/ifndef variety.
 * Flags whose names are followed by * must be specified with a value.
 * Some flags have default values, when noted.
 * Only those flags so documented may be changed by the customer
 * The meaning of the flags are as follows
 * machine (choose one):
 *   m_vax      a vax of any type (780,750, etc)
 *   m_68k      a 68000 or 68010
 * os (choose one if in the list, or else omit)
 *   os_vms     dec's vms os
 *   os_masscomp  masscomp's version of 4.2
 *   os_sun4    sun 4bsd or newer
 *   os_unisoft unisoft variant
 * OFFSET*      lowest address (where nil will be stored)
 * TTSIZE*      max number of 512 bytes pages for text and data
 *              !This may be altered!
 * XstackSize   size of alternate stack if SPISFP is defined
 * unisys3botch something is wrong with initialization of data space
 * SPISFP       the stack pointer is also the frame pointer, so we can't
 *              push tempories on the C stack (we have to use an alternate
 *              stack)
 * NPINREG      np and lbot are stored in registers rather than global
 *              variables
 * DefDmpmode*  default dump mode (expressed in octal-like decimal)
 * NILIS0       for any UNIX implementation in which the users
 *              address space starts at 0 (and liszt takes advantage
 *              of the fact)
 * StringTable  when the a.out format uses a string table for symbol
 *              names
 * Vadvise      if system has vadvise system call, this is the location
 *              of the vadvise include file.
 * OS*          name of the operating system for the (status features)
 *              list
 * Pagesize*    the size in bytes of a page of memory. Can be specified
 *              as a function to return the value.
 *
 * Machine*     name of the processor
 * LongFilenames  if this machine has very long filenames
 * Feature      something to be put on the status features list
 * vms_cfasl    for vms, do a cfasl of a native vms object file (i believe)
 * NewLineBuf   if it uses the setlinebuf call to set buffering for stdio
 * RIndexFcn*   function to call to get the location of a given char
 *		  from the end of the string.
 * IndexFcn*    function to call to get the location of a given char
 * machine name (choose one):
 *   GetHostname  has the 4.2 gethostname function
 *   os_masscomp  [this was mentioned above] use the masscomp version
 *               of gethostname
 *   SiteName    a string which is the site name, if it must be hardwired
 *               !this may be altered!
 * CallBrkdirect if must do a brk with a system call rather than the
 *               C function.
 * UseSetmask    signals are reenabled with sigsetmask rather than
 *               calling 'signal' again (a 4.2 feature)
 * unisys3botch  has a problem in clearing low memory (mysterious flag
 *               which should be better named)
 * SunCore       has suncore
 * Subxlbotch    operands of subxl exchanged [I'm guessing at this, it
 *               was underdocumented in the code]
 * NoSysTime    <sys/time.h> is <time.h>
 * NoSyscall    doesn't have a syscall function
 * NoAsm	doesn't have the function "asm" to insert assembler into the
 *		output of the C compiler (like the cadmus).
 * AsmOnly	This macro is defined in files which are really
		assembler files and the C pre-processor is being used.
		(The purpose is to keep typedef's from being passed
		to the assembler.)
 * NoGarbColl	Turns off garbage collection permanently.
		(This is done by making sure that Initflag does not
		get changed in sysat.c
 *
 * unchar  [default 'unsigned char'] the data type to use for unsigned
 *              character.  This is necessary since some C compilers can't
 *              handle 'unsigned char'.
 * word		An integer type (long, int, or short) whose size is the
		same as that of a pointer so that casts back and forth
		to (int *) or (char *) will not lose information.
 * int32	An integer type (long, int, or short) whose size is 
		32 bits.
 *
 * xor          [ default uses ^] a macro to xor two quantities.  This is
 *              necessary on ibm systems which use the caret for something
 *              else
 * Incl_ctype   [default: defined] if defined then explicitly include
 *              <ctype.h>
 *              
 * IobName      Indicates that a special machine and/or O.S. routine must be
 *              called to determine the locained] has floating point
 * HasTermcap   [default: defined] has interface to termcap
 *   ...        stdio flag conversions:  this should not be here when
 *              we are done moving stdio
 * DefLibDir    default lisp library directory
 * NoLowInput	Indicates that no attempt should be made to interfere with
 *		low level input routine (read). Otherwise, read is
 *		rewritten in 68k.c
 * NoLowOutput  Indicates that no attempt should be made to interfere with
 *		low level output routine (write). Otherwise, write is
 *		rewritten in 68k.c
 * Savelisp	needs the save/restorelisp feature [apollo]
 * UseOnlySdotsForBignums
 *		if defined, use only sdots for constructing bignums.
 *		This is for the apollo, and if Savelisp is defined, then
 *		this also MUST be defined. [apollo]
 * NoDumpLisp	this machine cannot support (dumplisp) [apollo]
 * NoNlist	this machine does not have the UNIX function nlist() [apollo]
 * ReadDir	If defined, uses unix system call to read a directory
 *		listing.
 */

/* defaults */

#define unchar unsigned char
#define xor(a,b)   (a) ^ (b)
#define Incl_ctype 
#define GcTime
#define HasFloat
#define HasTermcap
#define XstackSize 16384
#define DefLibDir "/usr/lib/lisp"

/*
** If more machines have weird integer sizes,
** these typedefs will have to be moved.
*/
#ifndef AsmOnly
#ifdef Elxsi
	typedef int int32;
	typedef int word;
#else
#ifdef lint
	typedef int int32;
	typedef int word;
#else
	typedef long int32;
	typedef long word;
#endif lint
#endif Elxsi
#endif AsmOnly

#ifdef vax_4_1
# define m_vax
# define OFFSET 0x0
# define TTSIZE 6120
# define NPINREG
# define DefDmpmode 413
# define NILIS0
# define StringTable
# define Vadvise <vadvise.h>
# define OS "unix"
# define Pagesize 1024
# define Machine "vax"
# define IndexFcn index
# define RIndexFcn rindex
# define SiteName "unknown-site"
#define nargsdefined
#define ReadDir
#endif

#ifdef vax_4_1a
# define m_vax
# define OFFSET 0x0
# define TTSIZE 6120
# define NPINREG
# define DefDmpmode 413
# define NILIS0
# define StringTable
# define Vadvise <vadvise.h>
# define OS "unix"
# define Pagesize 1024
# define Machine "vax"
# define IndexFcn index
# define RIndexFcn rindex
# define GetHostname
#define nargsdefined
#define ReadDir
#endif

#ifdef vax_4_1c
# define m_vax
# define OFFSET 0x0
# define TTSIZE 6120
# define NPINREG
# define DefDmpmode 413
# define NILIS0
# define StringTable
# define Vadvise <vadvise.h>
# define OS "unix"
# define Pagesize getpagesize()
# define Machine "vax"
# define LongFilenames
# define IndexFcn index
# define RIndexFcn rindex
# define GetHostname
#define nargsdefined
#define ReadDir
#endif

#ifdef vax_4_2
# define m_vax
# define OFFSET 0x0
# ifdef HOLE
#   define TTSIZE 10216
# else
#   define TTSIZE 6120
# endif
# define NPINREG
# define DefDmpmode 413
# define NILIS0
# define StringTable
# define Vadvise <sys/vadvise.h>
# define OS "unix"
# define Pagesize getpagesize()
# define Machine "vax"
# define LongFilenames
# define IndexFcn index
# define RIndexFcn rindex
# define GetHostname
# define CallBrkdirect
# define UseSetmask
#define nargsdefined
#define ReadDir
#endif

#ifdef vax_unix_ts
# define m_vax
# define OFFSET 0x0
# define TTSIZE 6120
# define NPINREG
# define DefDmpmode 410
# define NILIS0
# define OS "unix"
# define Pagesize 1024
# define Machine "vax"
# define IndexFcn strchr
# define RIndexFcn strrchr
# define SiteName "unknown-site"
#define nargsdefined
#define ReadDir
#endif

#ifdef vax_eunice_vms
# define m_vax
# define os_vms
# define OFFSET 0x0
# define TTSIZE 10216
# define NPINREG
# define DefDmpmode 413
# define NILIS0
# define StringTable
# define OS "vms"
# define Pagesize 512
# define Machine "vax"
# ifndef EUNICE_UNIX_OBJECT_FILE_CFASL
#   define vms_cfasl
# endif
# define IndexFcn index
# define RIndexFcn rindex
# define SiteName "unknown-site"
#define nargsdefined
#define ReadDir
#endif

#ifdef sun_unisoft
# define m_68k
# define os_unisoft
# define OFFSET 0x40000
# define TTSIZE 6120
# define DefDmpmode 410
# define OS "unix"
# define Pagesize 512
# define Machine "68k"
# define Feature "unisoft"
# define IndexFcn index
# define RIndexFcn rindex
# define SiteName "unknown-site"
# define NoSyscall
#define nargsdefined
#endif

#ifdef dual_unisoft
# define m_68k
# define os_unisoft
# define OFFSET 0x800000
# define TTSIZE 6120
# define DefDmpmode 410
# define OS "unix"
# define Pagesize 512
# define Machine "68k"
# define Feature "unisoft"
# define IndexFcn index
# define RIndexFcn rindex
# define SiteName "unknown-site"
# define NoSyscall
#define nargsdefined
#endif

#ifdef pixel_unisoft
# define m_68k
# define os_unisoft
# define OFFSET 0x20000
# define TTSIZE 6120
# define DefDmpmode 410
# define OS "unix"
# define Pagesize 512
# define Machine "68k"
# define Feature "unisoft"
# define IndexFcn index
# define RIndexFcn rindex
# define SiteName "unknown-site"
# define NoSyscall
#endif

#ifdef lisa_unisys3
# define m_68k
# define os_unisoft
# define OFFSET 0x20000
# define TTSIZE 6120
# define unisys3botch   1
# define DefDmpmode 410
# define OS "unix"
# define Pagesize 1024
# define Machine "68k"
# define IndexFcn strchr
# define RIndexFcn strrchr
# define SiteName "unknown-site"
# define NoSyscall
#endif

#ifdef sun_4_1c
# define m_68k
# define os_sun4
# define OFFSET 0x8000
# define TTSIZE 6120
# define DefDmpmode 413
# define StringTable
# define Vadvise <vadvise.h>
# define OS "unix"
# define Pagesize getpagesize()
# define Machine "68k"
# define LongFilenames
# define Feature "sun"
# define IndexFcn index
# define RIndexFcn rindex
# define GetHostname
# define SunCore
# define Subxlbotch
#define nargsdefined
#define ReadDir
#endif

#ifdef sun_4_2beta      /* sun release 1.0 */
# define m_68k
# define os_sun4
# define OFFSET 0x8000
# define TTSIZE 10216
# define SPISFP
# define DefDmpmode 413
# define StringTable
# define Vadvise <sys/vadvise.h>
# define OS "unix"
# define Pagesize getpagesize()
# define Machine "68k"
# define LongFilenames
# define Feature "sun"
# define NewLineBuf
# define IndexFcn index
# define RIndexFcn rindex
# define GetHostname
# define UseSetmask
# define SunCore
# define Subxlbotch
#define nargsdefined
#define ReadDir
#endif

#ifdef sun_4_2          /* sun release 1.1 */
# define m_68k
# define os_sun4
# define OFFSET 0x8000
# ifdef BIG
#  define TTSIZE 10216
# else
#  define TTSIZE 6120
# endif BIG
# define DefDmpmode 413
# define StringTable
# define Vadvise <sys/vadvise.h>
# define OS "unix"
# define Pagesize getpagesize()
# define Machine "68k"
# define LongFilenames
# define Feature "sun"
# define NewLineBuf
# define IndexFcn index
# define RIndexFcn rindex
# define GetHostname
# define UseSetmask
# define SunCore
# define nargsdefined
# define ReadDir
#endif

#ifdef mc500_2_2
# define m_68k
# define os_masscomp
# define growstackbotch
# define OFFSET 0x0
# define TTSIZE 6120
# define DefDmpmode 413
# define StringTable
/* seems to have disappeared # define Vadvise <sys/vadvise.h> */
# define OS "unix"
# define Machine "68k"
/* # define LongFilenames */
# define Feature "masscomp"
# define IndexFcn strchr
# define RIndexFcn strrchr
# define Pagesize 4096
# define NoSysTime
# define ReadDir
#endif

#ifdef pegasus
# define m_68k
# define OFFSET 0
# define TTSIZE 6120
/* SPISFP isn't quite true, but due to the way in which there is a phantom
 * spot on the stack, it is probably better that we use it
 */
# define growstackbotch
# define SPISFP
# undef  XstackSize
# define XstackSize 22000
# define DefDmpmode 413
# define OS "uniflex"
# define Machine "68k"
# define Feature "tek4404"
# define IndexFcn index
# define RIndexFcn rindex
# define SiteName "fi test machine"
# define NoSysTime
# define NoSyscall
# define NoAsm
# undef HasTermcap
# undef DefLibDir
# define DefLibDir "/lisp/lib"
/* stdio conversions */
# define _IOREAD _READ
# define _IOWRT  _WRITE
# define _IONBF  _UNBUF
# define _IOSTRG 0
# define _file _fd
/* end stdio conversions */
# define ReadDir
# define NoLowInput
#endif

#ifdef ibm_cms
# define m_ibm
# define os_cms
# define OFFSET ((int)&nilatom)
# define TTSIZE 6120
# define SPISFP
# define DefDmpmode 0407
# define OS "cms"
# define Pagesize 512
# define Machine "ibm"
# define IndexFcn "index"
# define RIndexFcn "rindex"
# define SiteName "ucb cms"
# define NoSyscall
/* it is a bug that unsigned char doesn't exist */
# undef unchar
# define unchar char
/* must define xor on ibm system to be the cent sign */
# include "ibmxor.h"
/* defined in stdio.h on ibm */
# undef Incl_ctype
# define IobName
# undef HasTermcap
#endif

#ifdef cadmus
# define m_68k
# define OFFSET 0x600000
# define CadmusOsBugs
# ifdef CadmusOsBugs
# define TTSIZE 8196
# else
# define TTSIZE 6120
# endif CadmusOsBugs
# define DefDmpmode 411
# define OS "unix"
# define Pagesize 1024
# define Machine "68k"
# define IndexFcn index
# define RIndexFcn rindex
# define SiteName "unknown-site"
# define NoSyscall
# define NoSysTime
# define NoAsm
# define Subxlbotch
# define Feature "cadmus"
#endif

#ifdef apollo
# define m_68k
# define Savelisp
# define NoDumpLisp
# define NoNlist
# define UseOnlySdotsForBignums
# define SPISFP
# define OFFSET ((int) &nilatom)
# define TTSIZE 6120
# define OS "aegis"
# define Pagesize 1024
# define Machine "68k"
# define IndexFcn index
# define RIndexFcn rindex
# define SiteName "unknown-site"
# define Feature "apollo"
# define NoSyscall
# define NoSysTime
# define NoAsm
# define NoLowInput	/* to avoid _read, _write */
# define NoLowOuput	/* to avoid _read, _write */
# define NewLineBuf
/* stdio conversions */
# define _IOREAD _SIRD
# define _IOWRT  _SIWR
# define _IONBF  _SIUNB
# define _IOSTRG 0
# define _file _fd
/* things written in asm can't have upper case in routine names */
# define Fixzero fixzero
# define Ifuncal ifuncal
# define Ipushf ipushf
# define Lastfix lastfix
# define Undeff undeff
#endif

#ifdef Elxsi
/* do not replace "Elxsi" with "elxsi" because elxsi is defined
   in the C preprosessor */
# define SPISFP
# define OFFSET 0x800
# define Machine "elxsi"
# define OS "enix"
# define _IOSTRG _IOMYBUF
# define NoLowInput	/* to avoid _read, _write */
# define NoLowOutput
# define NoSysTime
# define NoGarbColl
# define gstart() OFFSET  /* ??? */
# define Pagesize 1024
# define PAGSIZ 1024
# define TTSIZE 6120
# define DefDmpmode 410
# define IndexFcn strchr
# define RIndexFcn strrchr
# define SiteName "unknown-site"
#endif

#ifdef m_68k
#define SortSymbols
#endif

