/* utilities */

#include <stdio.h>
#include <strings.h>
#include <ctype.h>
#include <varargs.h>

/* uh-oh, looks like Lisp has a bcopy too! */
/* and it doesn't do the same thing as the C bcopy!  */
/* Now who wants to know how long this took me to find? */
static bcopy(s1,s2,length)
char *s1, *s2;
int length;
{
    while (0 < length--) *s2++ = *s1++;
}

void
safebcopy(b1,b2,length)
char *b1, *b2;
int length;
{
    eprintf(9,"safebcopy(%x,%x,%d)\n",b1,b2,length);
    if (!b1) {
	printf("error: bcopy dest is null ptr\n");
	abort();
    } else if (!b2) {
	printf("error: bcopy src is null ptr\n");
	abort();
    } else bcopy(b1,b2,length);
}

/* dump first 20 bytes starting at s in hex */
hex20(s)
char *s;
{
	int i;
	for (i=0;i<20;i++) printf("%2x",0xff & s[i]);
	putchar('\n');
}

/* dump length bytes worth of s in ascii */
ascii_dump(s,length)
char *s;
int length;
{
	int i;
	for (i=0;i<length;i++) {
		if (isascii(s[i]) && isprint(s[i])) {
			printf(" %c",s[i]);
		} else {
			printf(" %02x",0xff & s[i]);
		}
	}
	putchar('/n');
}

int cm_debug_level;   	/* controls how many debugging statements are
				/* printed.  0 means none, higher numbers mean
				/* more. */
/* levels are:
0	nothing
1
2	msgs send/received
3	msgs init, aborted
4
5	slots composed, decomposed
6	slots broken out
7
8
9	bcopy, strcpy, malloc
*/
set_cm_debug_level(level)
int level;
{
	cm_debug_level = level;
	eprintf(1,"cm debug level is %d\n",cm_debug_level);
}


/* Debugging function, use like printf, but the global var debug_level */
/* controls how much is printed */
#if 0
/* Yes, I know its gross */
/*VARARGS2*/
eprintf(level,fmt,v1,v2,v3,v4,v5,v6,v7,v8,v9)
int level;
char *fmt;
int v1, v2, v3, v4, v5, v6, v7, v8, v9;
{
	if (cm_debug_level >= level) printf(fmt,v1,v2,v3,v4,v5,v6,v7,v8,v9);
}
#endif

/*VARARGS2*/
eprintf(level,fmt,va_alist)
int level;
char *fmt;
va_dcl
{
	va_list pvar;

	va_start(pvar);
	/* & may be incorrect in following statement */
	if (cm_debug_level >= level) _doprnt(fmt,pvar,stderr);
	va_end(pvar);
}
