#include <stdio.h>
#include <sys/time.h>
#include <strings.h>
#include "cm_constants.h"
#include "cm_sd.h"
#include "cm_var.h"
#include "cm_interface.h"

void
cm_set_value(var,val)
cm_variable *var;
cm_value *val;
{
	eprintf(5,"var = %x\n",var);
	eprintf(5,"var->name = %s\n",var->name);
	cm_sd_copy(val,&var->data);
	var->status.written = TRUE;
	var->count++;
}


cm_value *
cm_get_value(var,val)
cm_variable *var;
cm_value *val;
{
	cm_sd_copy(&var->data,val);
	var->old_count = var->count;
	return(val);
}

void
cm_set_new_command_value(command_out,command_value)
cm_command_variable *command_out;
cm_value *command_value;
{
	cm_set_value(command_out,command_value);
	command_out->command_association++;
	/* or
	command_out->command_association = time_of_day;
	*/
}

/*
Note that whether we use a timestamp or a counter is implementation dependent.
The user should only see the association as an object that guarantees
uniqueness between commands.  Indeed, it is expected that variables will also
have timestamps and read/write counters, but this is irrelevent.
*/

boolean cm_new_command_pending(input_command)
cm_command_variable *input_command;
{
	return (input_command->command_association !=
		input_command->old_command_association);
}

/* returns true if variable has a new value since cm_get_value() or
   cm_get_new_command_value() has been called */
boolean cm_new_value_pending(var)
cm_variable *var;
{
	return (var->count != var->old_count);
}

boolean cm_get_new_value(var,val)
cm_variable *var;
cm_value *val;
{
	if (!cm_new_value_pending(var)) return(FALSE);

	cm_get_value(var,val);
	return(TRUE);
}

/* returns true if new command received.  turns off new flag */
boolean cm_get_new_command_value(input_command,value)
cm_command_variable *input_command;
cm_value *value;
{
	if (!cm_new_command_pending(input_command)) return(FALSE);

	/* turn off strobe for next time around */
	input_command->old_command_association =
		input_command->command_association;
	cm_get_value(input_command,value);
	return(TRUE);
}	

boolean
cm_status_equal(command_out,status_in,status_value)
cm_command_variable *command_out;
cm_status_variable *status_in;
cm_value *status_value;
{
	return(cm_status_synchronized(command_out,status_in) &&
		(cm_sd_equal(status_value,&status_in->data)
		   || (status_value == ANY_STATUS)));
}

boolean cm_status_synchronized(command_out,status_in)
cm_command_variable *command_out;
cm_status_variable *status_in;
{
	return(command_out->command_association ==
	         status_in->command_association);
}

/* NOTE: command_in argument is new!!! */
void cm_set_status_value(command_in,status_out,status_value)
cm_command_variable *command_in;
cm_status_variable *status_out;
cm_value *status_value;
{
	cm_set_value(status_out,status_value);
	status_out->command_association = command_in->command_association;
}
