/* these are utilities for dealing with timeouts */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include "cm_time.h"

struct timeval cm_period_zero, cm_period_infinite;

/* set up some useful constants */
cm_time_init()
{
	cm_time_zero(&cm_period_zero);
	cm_period_infinite.tv_sec = (u_long)1000000;
	cm_period_infinite.tv_usec = (long)0;
}

cm_time_zero(p)
struct timeval *p;
{
	p->tv_sec = (u_long)0;
	p->tv_usec = (long)0;
}

cm_time_set(p,s,u)
struct timeval *p;
int s;
int u;
{
	p->tv_sec = (u_long)s;
	p->tv_usec = (long)u;
}

cm_time_copy(from,to)
struct timeval *from, *to;
{
	safebcopy((char *)from,(char *)to,sizeof(struct timeval));
}
